/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryExpSupport;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class InQueryExp
extends QueryExpSupport {
    private ValueExp val;
    private ValueExp[] valueList;

    public InQueryExp() {
    }

    public InQueryExp(ValueExp valueExp, ValueExp[] valueExpArray) {
        this.val = valueExp;
        this.valueList = valueExpArray;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.valueList != null) {
            ValueExp valueExp = this.val.apply(objectName);
            boolean bl = valueExp instanceof NumericValueExp;
            int n = 0;
            while (n < this.valueList.length) {
                if (bl ? ((NumericValueExp)this.valueList[n]).doubleValue() == ((NumericValueExp)valueExp).doubleValue() : ((StringValueExp)this.valueList[n]).getValue().equals(((StringValueExp)valueExp).getValue())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String generateValueList() {
        if (this.valueList == null || this.valueList.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.valueList[0].toString());
        int n = 1;
        while (n < this.valueList.length) {
            stringBuffer.append(", ");
            stringBuffer.append(this.valueList[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public ValueExp getCheckedValue() {
        return this.val;
    }

    public ValueExp[] getExplicitValues() {
        return this.valueList;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.val)) + " in (" + this.generateValueList() + ")";
    }
}

