/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import webwork.config.Configuration;

public class XMLActionConfiguration
extends Configuration {
    HashMap actionMappings = new HashMap();
    Category log = Category.getInstance(this.getClass());

    public XMLActionConfiguration(String aName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(String.valueOf(aName) + ".xml");
            if (fileUrl == null) {
                throw new IllegalArgumentException("No such XML file:" + aName + ".xml");
            }
            Document document = factory.newDocumentBuilder().parse(fileUrl.toString());
            this.log.debug((Object)("Found XML view configuration " + fileUrl));
            NodeList actions = document.getElementsByTagName("action");
            int i = 0;
            while (i < actions.getLength()) {
                Element action = (Element)actions.item(i);
                String actionName = action.getAttribute("name");
                String actionAlias = action.getAttribute("alias");
                NodeList views = action.getElementsByTagName("view");
                int j = 0;
                while (j < views.getLength()) {
                    String actionViewName;
                    Element view = (Element)views.item(j);
                    if (!view.getParentNode().equals(action)) break;
                    NodeList viewMapping = view.getChildNodes();
                    StringBuffer mapping = new StringBuffer();
                    int k = 0;
                    while (k < viewMapping.getLength()) {
                        Node mappingNode = viewMapping.item(k);
                        if (mappingNode instanceof Text) {
                            mapping.append(mappingNode.getNodeValue());
                        }
                        ++k;
                    }
                    if ("".equals(actionAlias)) {
                        actionViewName = !"".equals(actionName) ? String.valueOf(actionName) + "." + view.getAttribute("name") : view.getAttribute("name");
                    } else {
                        actionViewName = String.valueOf(actionAlias) + "." + view.getAttribute("name");
                        this.log.debug((Object)("Adding action alias " + actionAlias + "=" + actionName));
                        this.actionMappings.put(String.valueOf(actionAlias) + ".action", actionName);
                    }
                    String actionViewMapping = mapping.toString().trim();
                    this.log.debug((Object)("Adding view mapping " + actionViewName + "=" + actionViewMapping));
                    this.actionMappings.put(actionViewName, actionViewMapping);
                    ++j;
                }
                NodeList commands = action.getElementsByTagName("command");
                int j2 = 0;
                while (j2 < commands.getLength()) {
                    Element command = (Element)commands.item(j2);
                    String commandName = command.getAttribute("name");
                    String commandAlias = command.getAttribute("alias");
                    if (!commandAlias.equals("")) {
                        this.log.debug((Object)("Adding command alias " + commandAlias + "=" + actionName + "!" + commandName));
                        this.actionMappings.put(String.valueOf(commandAlias) + ".action", String.valueOf(actionName) + "!" + commandName);
                    }
                    NodeList views2 = command.getElementsByTagName("view");
                    int k = 0;
                    while (k < views2.getLength()) {
                        Element view = (Element)views2.item(k);
                        NodeList viewMapping = view.getChildNodes();
                        StringBuffer mapping = new StringBuffer();
                        int l = 0;
                        while (l < viewMapping.getLength()) {
                            Node mappingNode = viewMapping.item(l);
                            if (mappingNode instanceof Text) {
                                mapping.append(mappingNode.getNodeValue());
                            }
                            ++l;
                        }
                        String commandViewName = commandAlias.equals("") ? (actionAlias.equals("") ? String.valueOf(actionName) + "!" + commandName + "." + view.getAttribute("name") : String.valueOf(actionAlias) + "!" + commandName + "." + view.getAttribute("name")) : String.valueOf(commandAlias) + "." + view.getAttribute("name");
                        String commandViewMapping = mapping.toString().trim();
                        this.log.debug((Object)("Adding command view mapping " + commandViewName + "=" + commandViewMapping));
                        this.actionMappings.put(commandViewName, commandViewMapping);
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        catch (SAXException e) {
            this.log.error((Object)"SAX exception", (Throwable)e);
            throw new IllegalArgumentException("Could not parse XML action configuration");
        }
        catch (IOException e) {
            this.log.error((Object)"IO exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)"Parser conf exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        catch (DOMException e) {
            this.log.error((Object)"DOM exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        String mappingName = this.replaceExtension(aName);
        Object mapping = this.actionMappings.get(mappingName);
        if (mapping == null) {
            throw new IllegalArgumentException("No such view mapping:" + mappingName);
        }
        return mapping;
    }

    public Iterator listImpl() {
        return this.actionMappings.keySet().iterator();
    }

    private String replaceExtension(String actionName) {
        String ext = "." + Configuration.getString("webwork.action.extension");
        if (actionName != null && !".action".equals(ext)) {
            int idx;
            if (actionName.endsWith(ext)) {
                actionName = String.valueOf(actionName.substring(0, actionName.lastIndexOf(ext))) + ".action";
            }
            if ((idx = actionName.indexOf(String.valueOf(ext) + "?")) > 0) {
                actionName = String.valueOf(actionName.substring(0, idx)) + ".action?" + actionName.substring(idx + ext.length() + 1);
            }
        }
        return actionName;
    }

    public void setImpl(String aName, Object aValue) {
        throw new UnsupportedOperationException("May not update XML view mapping");
    }
}

