/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"


// The constant compressor
char ConstantCompressor::IsRejecting()               
{  
	return TRUE;   
}
char ConstantCompressor::CanOverlap()                
{  
	return TRUE;   
}
unsigned short ConstantCompressor::GetContainerNum() 
{  
	return 0;   
}

static char *unescape(char *s, int len)
{
	char *t = new char[len+1], c;
	int i = 0, j = 0;

	while (i<len) {
		if ((c = s[i++]) == '\\') {
			/* unescape */
			switch ((c=s[i++])) {
				case 't':
					c = '\t';
					break;
				case 'n':
					c = '\n';
					break;
				case 'r':
					c = '\r';
					break;
				default:
					/* leave char as-is */
					break;
			}
		}
		t[j++] = c;
	}
	t[j] = '\0';

	return t;
}

ConstantCompressor::ConstantCompressor(Session *s, char *str,unsigned len): UserCompressor(s)
{
   datasize=0;contnum=0;isrejecting=1;canoverlap=1;isfixedlen=0;

   constantstr = unescape(str, len);
   constantstrlen=strlen(constantstr);
}

ConstantCompressor::~ConstantCompressor()
{
   trydela (constantstr);
}

char ConstantCompressor::ParseString(char *str,unsigned len,char *dataptr)
{
   char *ptr=constantstr;

   while(len--)
   {
      if(*ptr!=*str)
         return 0;
      ptr++;
      str++;
   }
   return 1;
}

void ConstantCompressor::CompressString(char *str,unsigned len,CompressContainer *cont,char *dataptr)
{
}

ConstantUncompressor::ConstantUncompressor(Session *s, char *str,unsigned len): UserUncompressor(s)
{
   datasize=0;contnum=0;

   constantstr = unescape(str, len);
   constantstrlen=strlen(constantstr);
}

ConstantUncompressor::~ConstantUncompressor()
{
   trydela (constantstr);
}

void ConstantUncompressor::UncompressItem(UncompressContainer *cont,char *dataptr,XMLOutput *xoutput)
{
   xoutput->characters(constantstr,constantstrlen);
}

char *ConstantCompressorFactory::GetName()         
{  
	return "\"...\""; 
}
char *ConstantCompressorFactory::GetDescription()  
{  
	return "Constant compressor"; 
}

ConstantCompressorFactory::ConstantCompressorFactory(Session *s, int comp) : UserCompressorFactory(s, comp) 
{}

UserCompressor *ConstantCompressorFactory::InstantiateCompressor(char *paramstr,int len)
{
   if(paramstr==NULL)
   {
      throw new XMillException(XMILL_ERR_ARGUMENTS, "Constant text compressor 'c' requires string argument");
   }
   if((*paramstr!='"')||(paramstr[len-1]!='"'))
   {
      XMillException *e = new XMillException(XMILL_ERR_ARGUMENTS, "Parameter '");
      e->ErrorCont(paramstr,len);
      e->ErrorCont("' is not a string");
      throw e;
   }
   return new ConstantCompressor(session,paramstr+1,len-2);
}

UserUncompressor *ConstantCompressorFactory::InstantiateUncompressor(char *paramstr,int len)
{
   if(paramstr==NULL)
   {
      throw new XMillException(XMILL_ERR_ARGUMENTS, "Constant text compressor 'c' requires string argument");
   }
   if((*paramstr!='"')||(paramstr[len-1]!='"'))
   {
      XMillException *e = new XMillException(XMILL_ERR_ARGUMENTS, "Parameter '");
      e->ErrorCont(paramstr,len);
      e->ErrorCont("' is not a string");
      throw e;
   }
   return new ConstantUncompressor(session, paramstr+1,len-2);
}
