/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module contains the memory manager for XMill
// The memory manager can handle four different block sizes (see below).
// and the blocks are hierarchically organized.

// This module contains several auxiliary function for the
// memory management

#include "stdafx.h"

/* RO globals */
unsigned long blocksizes[BLOCKSIZE_NUM]=
{TINYBLOCK_SIZE,SMALLBLOCK_SIZE,MEDIUMBLOCK_SIZE,LARGEBLOCK_SIZE};
   // For each possible block size,
   // we store the size

int size = 0;

// The memory management for large blocks
char *Session::AllocateBlockRecurs(unsigned char blocksizeidx)
   // Allocates a new large block recursively
   // I.e. if there is no block in the free list, we try to allocate
   // a block of the next higher size
{
   char *ptr;

   // Do we have any free block?
   if(freeblocklists[blocksizeidx]!=NULL)
   {
      ptr=freeblocklists[blocksizeidx];
      freeblocklists[blocksizeidx]=*(char **)freeblocklists[blocksizeidx];
      return ptr;
   }
   else
   {
      if(blocksizeidx==BLOCKSIZE_NUM-1)
         // Is this the largest possible block size??
         // We must allocate new space!
      {
			if (!(ptr=(char *)mymalloc(blocksizes[blocksizeidx]))) {
            ExitNoMem();
			}
         return ptr;
      }
      else  // If we haven't reached the largest possible block size,
            // We allocate a block of the next larger block size
            // and use it as a container for our blocks
      {
			/*_CrtMemState state1, state2, state3;
			_CrtMemCheckpoint(&state1);
			char *boe = (char*)malloc(200);
			char *boer = new char[205];
			/*setCheckAddress(boe);
			tryfree(boe);* /
			_CrtMemCheckpoint(&state2);
			_CrtMemDifference(&state3,&state1,&state2);
			_CrtMemDumpStatistics(&state3);
			*/

			ptr=AllocateBlockRecurs(blocksizeidx+1);

         // We add the new blocks to the free list
         char  *ptr1=ptr+blocksizes[blocksizeidx],
               *endptr=ptr+blocksizes[blocksizeidx+1];

         do
         {
            *(char **)ptr1=freeblocklists[blocksizeidx];
            freeblocklists[blocksizeidx]=ptr1;

            ptr1+=blocksizes[blocksizeidx];
         }
         while(ptr1<endptr);

         return ptr;
      }
   }
}

void Session::FreeBlocks()
{
	for (int i=0; i<BLOCKSIZE_NUM; i++) {
		if (freeblocklists[i]) {
			//free (freeblocklists[i]);
			freeblocklists[i] = NULL;
		}
	}
}

// Allocates a new memory block
// and increases the allocated memory count
char *Session::AllocateBlock(unsigned char blocksizeidx)
{
   allocatedmemory+=blocksizes[blocksizeidx];
   return AllocateBlockRecurs(blocksizeidx);
}

// Frees a memory block
void Session::FreeBlock(char *ptr,unsigned char blocksizeidx)
{
   *(char **)ptr=freeblocklists[blocksizeidx];
   freeblocklists[blocksizeidx]=ptr;

#ifdef RELEASEMEM_SAFE
   memset(ptr+4,0xcd,blocksizes[blocksizeidx]-4);
#endif

   allocatedmemory-=blocksizes[blocksizeidx];
}

// Returns the block size for a specific index
unsigned long Session::GetBlockSize(unsigned char blocksizeidx)
{
   return blocksizes[blocksizeidx];
}

// For the decompressor, we implement an additional memory management
// A single memory block is allocated (and can be reallocated, if it is
// too small) and data is stored within that block
// from the start to the end

void Session::SetMemoryAllocationSize(unsigned long allocsize)
   // Sets the amount of memory needed. If the current block is too small,
   // the current block is reallocated.
{
   if(memoryalloc_bufsize<allocsize)
      // Current block is too small?
   {
      // Let's reallocate
      tryfree(memoryalloc_buf);

      memoryalloc_buf=(unsigned char *)mymalloc(allocsize);
      if(memoryalloc_buf==NULL)
         ExitNoMem();

      memoryalloc_curptr   =memoryalloc_buf;
      memoryalloc_bufsize  =allocsize;
   }
   else
      // If we have enough space, we just use the existing block
      memoryalloc_curptr=memoryalloc_buf;
}

void Session::WordAlignMemBlock()
   // We align the current pointer to an address divisible by 4
{
   memoryalloc_curptr=
      (unsigned char *)
      (((unsigned long)memoryalloc_curptr+3)&0xFFFFFFFCL);
}

unsigned char *Session::AllocateMemBlock(unsigned long size)
   // We allocate a new piece of data
{
   memoryalloc_curptr+=size;
   if(memoryalloc_curptr>memoryalloc_buf+memoryalloc_bufsize)
   {
      throw new XMillException(XMILL_ERR_FATAL, "memory fuckup");
   }
   return memoryalloc_curptr-size;
}

void Session::FreeMemBlock(void *ptr,unsigned long size)
   // We forget about freeing the block, since we will use the entire block
   // later again
{
}
