/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"

// The standard integer user compressor 'u'
UnsignedIntCompressor::UnsignedIntCompressor(Session *s, unsigned long mymindigits): UserCompressor(s)
{
   mindigits=mymindigits;
   datasize=0;contnum=1;isrejecting=1;canoverlap=1;isfixedlen=0;
}

char UnsignedIntCompressor::ParseString(char *str,unsigned len,char *dataptr)
   // We keep the parsed value in 'val'
{
   return ParseUnsignedInt(str,len,&val);
}

void UnsignedIntCompressor::CompressString(char *str,unsigned len,CompressContainer *cont,char *dataptr)
{
   cont->StoreUInt32(val);
}

UnsignedIntUncompressor::UnsignedIntUncompressor(unsigned long mymindigits): UserUncompressor()
{
	Init(mymindigits);
}

UnsignedIntUncompressor::UnsignedIntUncompressor(Session *s, unsigned long mymindigits): UserUncompressor(s)
{
	Init(mymindigits);
}

void UnsignedIntUncompressor::Init(unsigned long mymindigits)
{
   mindigits=mymindigits;
   datasize=0;contnum=1;
}

void UnsignedIntUncompressor::UncompressItem(UncompressContainer *cont,char *dataptr,XMLOutput *xoutput)
{
   PrintInteger(cont->LoadUInt32(),0,mindigits,xoutput);
}

char *UnsignedIntCompressorFactory::GetName()         
{  
	return "u"; 
}
char *UnsignedIntCompressorFactory::GetDescription()  
{  
	return "Compressor for unsigned integers"; 
}

UserCompressor *UnsignedIntCompressorFactory::InstantiateCompressor(char *paramstr,int len)
{
   unsigned long mindigits=0;
   if(paramstr!=NULL)
   {
      char savechar=paramstr[len];
      paramstr[len]=0;
      mindigits=atoi(paramstr);
      paramstr[len]=savechar;
      if(mindigits<=0)
      {
         XMillException *e = new XMillException(XMILL_ERR_ARGUMENTS, "Invalid parameter '");
         e->ErrorCont(paramstr,len);
         e->ErrorCont("' for compressor 'u'!");
         throw e;
      }
   }
   return new UnsignedIntCompressor(session, mindigits);
}

UserUncompressor *UnsignedIntCompressorFactory::InstantiateUncompressor(char *paramstr,int len)
{
   unsigned long mindigits=0;
   if(paramstr!=NULL)
   {
      char savechar=paramstr[len];
      paramstr[len]=0;
      mindigits=atoi(paramstr);
      paramstr[len]=savechar;
      if(mindigits<=0)
      {
         XMillException *e = new XMillException (XMILL_ERR_ARGUMENTS, "Invalid parameter '");
         e->ErrorCont(paramstr,len);
         e->ErrorCont("' for compressor 'u'!");
         throw e;
      }
      return new UnsignedIntUncompressor(session, mindigits);
   }
   else
      return &uncompressor;
}
