/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

#pragma once

#define MAX_BLOCKSIZE      (2L*1024L*1024L)
#define MIN_DATABLOCKSIZE  512

struct UnpackDataBlock {
   unsigned long     len;
   UnpackDataBlock   *next;
   // The data starts right after the last attribute !

   char *GetPtr() {  return (char *)(this+1);  }
   unsigned long GetLen() {  return len;  }
};

struct UnpackMemBlock
{
   unsigned long  len;
   unsigned long  used;
   UnpackMemBlock *next;
};

class UnpackMemMan
{
   UnpackMemBlock *firstblock,*lastblock;
   unsigned long  curmaxblocksize;
   unsigned long  neededmemoryspace;

   UnpackMemBlock *AllocateMemBlock(UnpackMemBlock **memblockref);

public:
   char Init(unsigned long myneededmemoryspace,unsigned long datablockcount);
   UnpackDataBlock *AllocateDataBlocks(unsigned long len);
};
