/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.products;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.model.FiveBean;
import com.thoughtworks.xstream.tools.benchmark.model.OneBean;
import java.io.InputStream;
import java.io.OutputStream;

public class XStreamDriver
implements Product {
    private final XStream xstream;
    private final String desc;

    public XStreamDriver(HierarchicalStreamDriver driver, String desc) {
        this.xstream = new XStream(driver);
        this.xstream.registerConverter((Converter)new JavaBeanConverter(this.xstream.getMapper()){

            public boolean canConvert(Class type) {
                return type == OneBean.class || type == FiveBean.class;
            }
        });
        this.desc = desc;
    }

    public void serialize(Object object, OutputStream output) throws Exception {
        this.xstream.toXML(object, output);
    }

    public Object deserialize(InputStream input) throws Exception {
        return this.xstream.fromXML(input);
    }

    public String toString() {
        return "XStream (" + this.desc + ")";
    }
}

