/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.dtd2js;

import com.conradroche.matra.decl.AttList;
import com.conradroche.matra.decl.Attribute;
import com.conradroche.matra.decl.DocType;
import com.conradroche.matra.decl.ElementType;
import com.conradroche.matra.dtdparser.DTDParser;
import com.conradroche.matra.exception.DTDException;
import com.conradroche.matra.io.DTDFile;
import com.conradroche.matra.io.DTDSource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ValidElementsParser {
    private static Hashtable elementList;
    private static Hashtable attributeList;
    private static Hashtable entityList;
    private static DTDParser dtdParser;
    private Vector<String> printedEleList;
    private String[] excludes;
    private FileOutputStream outputStrm = null;
    private OutputStreamWriter osw = new OutputStreamWriter(System.out);
    private OutputStreamWriter osw2;
    private BufferedWriter outputDevice;
    private String dataString = "";
    private Properties parseProperties;
    private boolean includeAttributes;

    public ValidElementsParser(String dtdInputFile, String dtdOutputFile, String dtdPropertiesFile, String exclude, boolean include_attributes) throws FileNotFoundException, DTDException, IOException {
        DTDFile testDTD = null;
        testDTD = new DTDFile(dtdInputFile);
        dtdParser = new DTDParser();
        if (exclude != null) {
            this.excludes = exclude.split(",");
        }
        this.includeAttributes = include_attributes;
        try {
            this.outputStrm = new FileOutputStream(dtdOutputFile);
            this.osw2 = new OutputStreamWriter(this.outputStrm);
            this.outputDevice = new BufferedWriter(this.osw2);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException();
        }
        if (dtdPropertiesFile != null) {
            this.readPropertiesFile(dtdPropertiesFile);
        } else {
            this.parseProperties = new Properties();
        }
        dtdParser.parse((DTDSource)testDTD);
        DocType newDoctype = dtdParser.getDocType();
        attributeList = newDoctype.getAllAttributes();
        elementList = newDoctype.getElementList();
        entityList = newDoctype.getEntityList();
    }

    private String printAttributes(String element) {
        AttList attlist = (AttList)attributeList.get(element);
        if (attlist == null) {
            return "[]";
        }
        Enumeration attribs = attlist.getAttribs().elements();
        if (!attribs.hasMoreElements()) {
            return "[]";
        }
        String str = "[";
        while (true) {
            Attribute currAttrib = (Attribute)attribs.nextElement();
            str = str + currAttrib.getAttributeName();
            if (!attribs.hasMoreElements()) break;
            str = str + "|";
        }
        str = str + "]";
        return str;
    }

    private void printElements(String rootElement, String elders, int level) throws DTDException {
        int rep;
        ElementType root;
        boolean exclude = false;
        if (this.excludes != null) {
            for (int i = 0; i < this.excludes.length; ++i) {
                if (!this.excludes[i].equals(rootElement)) continue;
                exclude = true;
                break;
            }
        }
        if (rootElement.equals("#PCDATA")) {
            return;
        }
        if (level == 0) {
            this.printedEleList = new Vector();
        }
        if ((root = (ElementType)elementList.get(rootElement)) == null) {
            throw new DTDException("Null value cannot be passed as root(" + rootElement + ").");
        }
        StringTokenizer st = new StringTokenizer(elders, ">");
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            if (!rootElement.equals(element)) continue;
            return;
        }
        elders = elders + ">" + rootElement;
        if (root.isAnyContentModel()) {
            return;
        }
        if (this.printedEleList.contains(rootElement)) {
            return;
        }
        if (!exclude) {
            this.dataString = this.dataString + rootElement;
            if (this.includeAttributes) {
                this.dataString = this.dataString + this.printAttributes(rootElement);
            }
        }
        this.printedEleList.addElement(rootElement);
        if (!root.hasChildren()) {
            if (!exclude) {
                this.dataString = this.dataString + "[]\n";
            }
            return;
        }
        String[] childNames = root.getChildrenNames();
        if (!exclude) {
            this.dataString = this.dataString + "[";
            for (rep = 0; rep < childNames.length - 1; ++rep) {
                this.dataString = !childNames[rep].equals("#PCDATA") ? this.dataString + childNames[rep] + "|" : this.dataString + "#|";
            }
            this.dataString = this.dataString + childNames[rep];
            this.dataString = this.dataString + "]\n";
        }
        for (rep = 0; rep <= childNames.length - 1; ++rep) {
            this.printElements(childNames[rep], elders, level + 1);
        }
    }

    public void printValidElements() throws DTDException, IOException {
        Enumeration roots = dtdParser.getDocType().getRootElements();
        this.printLookup();
        this.printElements((String)roots.nextElement(), "", 0);
        this.compress();
        this.convertToString();
        this.outputDevice.write(this.dataString);
        this.outputDevice.flush();
    }

    public void printLookup() throws IOException {
        int count = 0;
        this.outputDevice.write("unpack({\n");
        for (Object key : this.parseProperties.keySet()) {
            if (count++ > 0) {
                this.outputDevice.write(",\n");
            }
            this.outputDevice.write("\t" + key + " : '" + this.parseProperties.get(key) + "'");
        }
        this.outputDevice.write("\n}, ");
    }

    public void convertToString() {
        this.dataString = this.dataString.replaceAll("\n$", "");
        this.dataString = this.dataString.replaceAll("\n", "' + \n\t'");
        this.dataString = "'" + this.dataString + "'\n);";
    }

    public void readPropertiesFile(String propFile) throws IOException {
        this.parseProperties = new Properties();
        BufferedReader in = new BufferedReader(new FileReader(propFile));
        this.parseProperties.load(in);
        in.close();
    }

    private void compress() {
        Vector<String> v = new Vector<String>();
        for (Object key : this.parseProperties.keySet()) {
            v.add((String)key);
        }
        Collections.sort(v);
        Enumeration keys = v.elements();
        while (keys.hasMoreElements()) {
            String aKey = (String)keys.nextElement();
            String aValue = (String)this.parseProperties.get(aKey);
            this.dataString = this.dataString.replaceAll("\\Q" + aValue + "\\E", "\\" + aKey);
        }
    }
}

