/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.ant.tasks;

import com.moxiecode.moxiedoc.Processor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class MoxieDocTask
extends Task {
    protected String outDir;
    protected String templateDir;
    protected String msIntelliSense;
    protected String title;
    protected String eventClass;
    protected Vector<FileSet> filesets = new Vector();

    public void addFileSet(FileSet fileset) {
        if (!this.filesets.contains(fileset)) {
            this.filesets.add(fileset);
        }
    }

    public void execute() throws BuildException {
        Processor processor = new Processor();
        int secs = (int)System.currentTimeMillis() / 1000;
        File outDir = new File(this.outDir);
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        processor.setOutDir(outDir);
        processor.setTemplateDir(new File(this.templateDir));
        processor.setTitle(this.title);
        processor.setEventClass(this.eventClass);
        if (this.msIntelliSense != null) {
            processor.setMsIntelliSenseFile(new File(this.msIntelliSense));
        }
        for (FileSet fileset : this.filesets) {
            String[] filesInSet;
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            File dir = ds.getBasedir();
            for (String filename : filesInSet = ds.getIncludedFiles()) {
                File file = new File(dir, filename);
                processor.addFile(file);
            }
        }
        try {
            processor.process();
        }
        catch (Exception ex) {
            throw new BuildException("Processing of files failed.", (Throwable)ex);
        }
        secs = (int)System.currentTimeMillis() / 1000 - secs;
        this.log("Processed " + processor.getProcessedFileCount() + " files in " + secs + " second(s).", 2);
    }

    public void setOutDir(String path) {
        this.outDir = path;
    }

    public void setTemplateDir(String path) {
        this.templateDir = path;
    }

    public void setMsIntelliSense(String path) {
        this.msIntelliSense = path;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEventClass(String event_class) {
        this.eventClass = event_class;
    }
}

