/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.moxiedoc;

import com.moxiecode.moxiedoc.ParamTag;
import com.moxiecode.moxiedoc.ReturnTag;
import com.moxiecode.moxiedoc.SeeTag;
import com.moxiecode.moxiedoc.SourcePosition;
import com.moxiecode.moxiedoc.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentBlock {
    protected String rawText;
    protected String text;
    protected Tag[] tags;
    protected SourcePosition sourcePosition;

    CommentBlock(String raw_text, SourcePosition pos) {
        this.rawText = raw_text;
        this.sourcePosition = pos;
        this.parse(raw_text);
    }

    public String getText() {
        return this.text;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Tag[] getTags(String tag_name) {
        Vector<Tag> tags = new Vector<Tag>();
        for (Tag tag : this.tags) {
            if (!tag.getName().equals(tag_name)) continue;
            tags.add(tag);
        }
        Tag[] tagArray = new Tag[tags.size()];
        tags.toArray(tagArray);
        return tagArray;
    }

    public Tag getTag(String tag_name) {
        for (Tag tag : this.tags) {
            if (!tag.getName().equals(tag_name)) continue;
            return tag;
        }
        return null;
    }

    public ParamTag[] getParams() {
        Vector<ParamTag> paramTags = new Vector<ParamTag>();
        for (Tag tag : this.tags) {
            if (!tag.getName().equals("param")) continue;
            paramTags.add((ParamTag)tag);
        }
        ParamTag[] paramTagArray = new ParamTag[paramTags.size()];
        paramTags.toArray(paramTagArray);
        return paramTagArray;
    }

    public Tag[] getExamples() {
        Vector<Tag> exampleTags = new Vector<Tag>();
        for (Tag tag : this.tags) {
            if (!tag.getName().equals("example")) continue;
            exampleTags.add(tag);
        }
        Tag[] examplesTagArray = new Tag[exampleTags.size()];
        exampleTags.toArray(examplesTagArray);
        return examplesTagArray;
    }

    public SeeTag[] getSeeTags() {
        Vector<SeeTag> seeTags = new Vector<SeeTag>();
        for (Tag tag : this.tags) {
            if (!tag.getName().equals("see")) continue;
            seeTags.add((SeeTag)tag);
        }
        SeeTag[] seeTagArray = new SeeTag[seeTags.size()];
        seeTags.toArray(seeTagArray);
        return seeTagArray;
    }

    public boolean hasTag(String tag_name) {
        return this.getTag(tag_name) != null;
    }

    public SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Text: " + this.text + " (" + this.getSourcePosition() + ")\n");
        for (Tag tag : this.tags) {
            buffer.append(" " + tag.toString() + "\n");
        }
        return buffer.toString();
    }

    private void parse(String raw_text) {
        String line = null;
        StringBuffer textBuffer = new StringBuffer();
        boolean foundTag = false;
        int lineNum = 0;
        Vector<Tag> tags = new Vector<Tag>();
        try {
            Pattern tagPattern = Pattern.compile("^\\s*@([^\\s]+)\\s*(.+)?$", 2);
            Tag tag = null;
            BufferedReader in = new BufferedReader(new StringReader(raw_text));
            while ((line = in.readLine()) != null) {
                line = line.replaceAll("^\\/?\\*+\\s?", "");
                Matcher tagMatcher = tagPattern.matcher(line = line.replaceAll("\\**\\/$", ""));
                if (tagMatcher.matches()) {
                    if (!foundTag) {
                        this.text = textBuffer.toString();
                        foundTag = true;
                    }
                    textBuffer = new StringBuffer();
                    String tagName = tagMatcher.group(1);
                    String tagText = tagMatcher.group(2);
                    SourcePosition pos = new SourcePosition(this.sourcePosition.getFilePath(), this.sourcePosition.getLineNumber() + lineNum);
                    if (tagText == null) {
                        tagText = "";
                    }
                    tag = tagName.equals("param") ? new ParamTag(tagName, tagText, pos) : (tagName.equals("return") ? new ReturnTag(tagName, tagText, pos) : (tagName.equals("see") ? new SeeTag(tagName, tagText, pos) : new Tag(tagName, tagText, pos)));
                    tags.add(tag);
                } else if (tag == null) {
                    if (textBuffer.length() > 0) {
                        textBuffer.append('\n');
                    }
                    textBuffer.append(line);
                } else {
                    if (tag.getRawText().length() > 0) {
                        tag.setRawText(tag.getRawText() + "\n");
                    }
                    tag.setRawText(tag.getRawText() + line);
                }
                ++lineNum;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.tags = new Tag[tags.size()];
        tags.toArray(this.tags);
    }
}

