/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.ant.tasks;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YuiCompressTask
extends Task {
    protected String charset = "ISO-8859-1";
    protected String inFile;
    protected String outFile;
    protected int lineBreakPosition = -1;
    protected boolean munge = true;
    protected boolean warn = false;
    protected boolean preserveAllSemiColons = false;
    protected boolean optimize = true;

    public void execute() throws BuildException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(this.inFile), this.charset);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), this.charset);
            if (this.inFile == null || this.outFile == null) {
                throw new BuildException("Missing required: infile or outfile parameter.");
            }
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, new ErrorReporter(){

                private String getMessage(String source, String message, int line, int lineOffset) {
                    String logMessage = line < 0 ? (source != null ? source + ":" : "" + message) : (source != null ? source + ":" : "" + line + ":" + lineOffset + ":" + message);
                    return logMessage;
                }

                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    YuiCompressTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 1);
                }

                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    YuiCompressTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 0);
                }

                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    YuiCompressTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 0);
                    return new EvaluatorException(message);
                }
            });
            compressor.compress((Writer)out, this.lineBreakPosition, this.munge, this.warn, this.preserveAllSemiColons, !this.optimize);
        }
        catch (IOException ex) {
            throw new BuildException("I/O Error when preprocessing file", (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new BuildException("I/O Error when preprocessing file", (Throwable)ex);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                throw new BuildException("I/O Error when preprocessing file", (Throwable)ex);
            }
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLineBreakPosition(int lineBreakPosition) {
        this.lineBreakPosition = lineBreakPosition;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setInFile(String in_file) {
        this.inFile = in_file;
    }

    public void setOutFile(String out_file) {
        this.outFile = out_file;
    }
}

