from Products.CMFCore.utils import getToolByName
## PloneBatch currently has problems
# from Products.CMFPlone.PloneBatch import Batch
from ZTUtils.Batch import Batch
from zope.publisher.browser import BrowserView

from .interfaces import IContentListing


class FolderListing(BrowserView):

    def __call__(self, batch=False, b_size=20, b_start=0, orphan=0, **kw):
        query = {}
        query.update(kw)

        query['path'] = {'query': '/'.join(self.context.getPhysicalPath()),
                         'depth': 1}

        # if we don't have asked explicitly for other sorting, we'll want
        # it by position in parent
        if 'sort_on' not in query:
            query['sort_on'] = 'getObjPositionInParent'

        # Provide batching hints to the catalog
        if batch:
            query['b_start'] = b_start
            query['b_size'] = b_size + orphan

        catalog = getToolByName(self.context, 'portal_catalog')
        results = catalog(query)
        if batch:
            results = Batch(results, b_size, b_start, orphan=orphan)
        return IContentListing(results)
