/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class InitializationVectorParameters
implements Parameters {
    protected byte[] initializationVector_;

    public InitializationVectorParameters(byte[] initializationVector) {
        if (initializationVector == null) {
            throw new NullPointerException("Argument \"initializationVector\" must not be null.");
        }
        this.initializationVector_ = initializationVector;
    }

    public Object clone() {
        InitializationVectorParameters clone;
        try {
            clone = (InitializationVectorParameters)super.clone();
            clone.initializationVector_ = (byte[])this.initializationVector_.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", ex);
        }
        return clone;
    }

    public Object getPKCS11ParamsObject() {
        return this.initializationVector_;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector_;
    }

    public void setInitializationVector(byte[] initializationVector) {
        if (initializationVector == null) {
            throw new NullPointerException("Argument \"initializationVector\" must not be null.");
        }
        this.initializationVector_ = initializationVector;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("Initialization Vector (hex): ");
        buffer.append(Functions.toHexString(this.initializationVector_));
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof InitializationVectorParameters) {
            InitializationVectorParameters other = (InitializationVectorParameters)otherObject;
            equal = this == other || Functions.equals(this.initializationVector_, other.initializationVector_);
        }
        return equal;
    }

    public int hashCode() {
        return Functions.hashCode(this.initializationVector_);
    }
}

