/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.freebsd;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.branding.BrandingUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.os.freebsd.Messages;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static boolean gconfAvailable = false;
    private static final String PK_ASK_FOR_WORKAROUND = "org.eclipse.wb.os.freebsd.compizDontAskForWorkaround";
    public static final String PLUGIN_ID = "org.eclipse.wb.os.freebsd";
    private static Activator m_plugin;
    private static final Map<String, Image> m_nameToIconMap;

    static {
        try {
            System.loadLibrary("wbp-compiz");
            gconfAvailable = true;
        }
        catch (Throwable throwable) {}
        m_nameToIconMap = Maps.newHashMap();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
        this.scheduleCompizCheck();
    }

    public void stop(BundleContext context) throws Exception {
        m_plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return m_plugin;
    }

    public static InputStream getFile(String path) {
        try {
            URL url = new URL(Activator.getInstallURL(), path);
            return url.openStream();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    public static URL getInstallURL() {
        return Activator.getInstallUrl((Plugin)Activator.getDefault());
    }

    private static URL getInstallUrl(Plugin plugin) {
        return plugin.getBundle().getEntry("/");
    }

    public static Image getImage(String path) {
        Image image = m_nameToIconMap.get(path);
        if (image == null) {
            InputStream is = Activator.getFile("icons/" + path);
            try {
                image = new Image((Device)Display.getCurrent(), is);
                m_nameToIconMap.put(path, image);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRunningCompiz() {
        try {
            File[] procFiles;
            File procs = new File("/proc");
            File[] fileArray = procFiles = procs.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            int n = procFiles.length;
            int n2 = 0;
            while (true) {
                String cmdLine;
                if (n2 >= n) {
                    return false;
                }
                File procDir = fileArray[n2];
                File cmdLineFile = new File(procDir, "cmdline");
                if (cmdLineFile.exists() && (cmdLine = IOUtils2.readString((File)cmdLineFile)).indexOf("compiz") != -1) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private boolean askAgain() {
        String value = this.getPreferenceStore().getString(PK_ASK_FOR_WORKAROUND);
        return StringUtils.isEmpty((String)value);
    }

    private boolean isCompizSet() {
        return Activator._isCompizSet();
    }

    private void setupCompiz() {
        Activator._setupCompiz();
    }

    private void scheduleCompizCheck() {
        if (!gconfAvailable) {
            return;
        }
        Activator.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    MessageDialogWithToggle dialog;
                    int returnCode;
                    if (Activator.this.isRunningCompiz() && !Activator.this.isCompizSet() && Activator.this.askAgain() && (returnCode = (dialog = MessageDialogWithToggle.openYesNoQuestion(null, (String)BrandingUtils.getBranding().getProductName(), (String)Messages.Activator_compizMessage, (String)Messages.Activator_compizDontAsk, (boolean)false, (IPreferenceStore)Activator.this.getPreferenceStore(), (String)Activator.PK_ASK_FOR_WORKAROUND)).getReturnCode()) == 2) {
                        Activator.this.setupCompiz();
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        });
    }

    private static native boolean _setupCompiz();

    private static native boolean _isCompizSet();
}

