/*
 * Quantis C++ Library
 *
 * Copyright (c) 2004-2010 id Quantique SA, Carouge/Geneva, Switzerland
 * All rights reserved.
 *
 * ----------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY.
 *
 * ----------------------------------------------------------------------------
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * ----------------------------------------------------------------------------
 *
 * For history of changes, see ChangeLog.txt
 */

#ifndef QUANTIS_HPP
#define QUANTIS_HPP

#include <string>
#include <stdexcept>

#include "Quantis.h"

#ifdef _WIN32
  // Visual C++ does not implement checked exceptions
  // Disables "C++ exception specification ignored except to indicate a function is not __declspec(nothrow)"
# pragma warning(disable: 4290) 
#endif

namespace idQ
{
  class DLL_EXPORT Quantis
  {
    public:
      /**
       *
       * @param deviceType
       * @param deviceNumber
       * @return
       */
      Quantis(QuantisDeviceType deviceType, unsigned int deviceNumber)
          throw(std::runtime_error);

      /**
       *
       * @return
       */
      ~Quantis();

      /**
       *
       */
      void BoardReset() const
        throw(std::runtime_error);

      static int Count(QuantisDeviceType deviceType)
          throw(std::runtime_error);

      int GetBoardVersion() const
          throw(std::runtime_error);

      float GetDriverVersion() const
          throw(std::runtime_error);

      static float GetDriverVersion(QuantisDeviceType deviceType)
          throw(std::runtime_error);

      static float GetLibVersion();

      int GetModulesCount() const
          throw(std::runtime_error);

      int GetModulesMask() const
          throw(std::runtime_error);

      int GetModulesDataRate() const
          throw(std::runtime_error);

      bool GetModulesPower() const
          throw(std::runtime_error);

      int GetModulesStatus() const
          throw(std::runtime_error);

      std::string GetSerialNumber() const;

      void ModulesDisable(int modulesMask) const
          throw(std::runtime_error);

      void ModulesEnable(int modulesMask) const
          throw(std::runtime_error);

      void ModulesReset(int modulesMask) const
          throw(std::runtime_error);

      std::string Read(size_t size) const
          throw(std::runtime_error);

      void Read(void* buffer, size_t size) const
          throw(std::runtime_error);

      double ReadDouble() const
        throw(std::runtime_error);

      double ReadDouble(double min, double max) const
          throw(std::runtime_error);

      float ReadFloat() const
        throw(std::runtime_error);
      
      float ReadFloat(float min, float max) const
          throw(std::runtime_error);

      int ReadInt() const
          throw(std::runtime_error);

      int ReadInt(int min, int max) const
          throw(std::runtime_error);

      short ReadShort() const
          throw(std::runtime_error);

      short ReadShort(short min, short max) const
          throw(std::runtime_error);
  };
}

#endif
