//=============================================================================
// AEonsDM.
//=============================================================================
class AEonsDM expands DeathMatchGame;

// Coded by Christoph "AEon" Loewe, part of the AEstats package... (C) 1998-1999
// All Rights Reservered... Provided as is...
// Web: AEons.gametown.de/AEstats/
//
//Log ouput done via function (shadowing) 
//  Engine.GameInfo             Killed()
//  UnrealShare.DeathMatchGame  Killed()
//and "piping" some of the DM related info to Unreal Log file with log("").
//
//DamageType(s) == 'exploded', 'suicided', 'fell', 'drowned', 'Special', 'Burned', 'Corroded'
//In game:       jolted, Corroded, exploded, shredded, shot 
//Envirodeaths:  fell, drowned (these make sense)


// $VER 2.24 - 08.05.99 22:20 (AEonsDMmod.u v3.98 r3)
// - all string[] to string (Unreal does ist own dynamic allocation now).
// - new Killed() from  Engine.GameInfo and UnrealShare-DeathMatchGame
// - There are a lot of really weird special cases in the else tree of
//   if ( (Killer == Other) || (Killer == None) )... ignoring them for now

// $VER 2.20 - 24.04.99 15:01 (AEonsDMmod.u v3.98)
//
// - Player and Map names that have a "/" in the string will confuse preAEs...
//   Filtering out the "/" and replacing it with a " " (blank)

// $VER 2.20 - 03.02.99 20:43 (AEonsDMmod.u v3.90)
//
// - bClassicDeathmessages id by default true... the old mode in pre 2.20 was like this
//   else mode not changed...
// - killed = Other.PlayerName; is now killed = Other.PlayerReplicationInfo.PlayerName;
//   note that PlayerReplicationInfo seems to filter the data... hope script works...
// - No matter what the DM text mode is classic or new DM messages... log output
//   will be generated
// - UnrealShare.DeathMatchGame  Killed(), contents also had to be shadowed!!!!!

//
// Display a death message. AEon: (Engine.GameInfo)
//
function Killed( pawn killer, pawn Other, name damageType )
{
	local string killed;
	local string message;
	local string KillerWeaponName;  //new224
	local string VictimWeaponName;  //new224
	local string DeathMessage;      //new224 
	local string killerName;        //AEon->
	local string mapName;
	local string logmsg;
	local string datestamp;
	local string zero;
        local int i;
        local int pos;
        local int lenName;              //<-AEon


	if (Other.bIsPlayer)
	{
        killed = Other.PlayerReplicationInfo.PlayerName;                //AEon->
        // Should fix the one warning I get on double deaths ?
		// Line below is NEEDED to fix player names
        if( killer!=None )
                killerName = killer.PlayerReplicationInfo.PlayerName;   //<-AEon

		// Filter out "/" in names... and replace it with " " (a blank)
		//---------------- 
		if( InStr(killed,"/")>=0 ){
			lenName=Len(killed);
			// A maximum of name length "/"s are possible
			for(i=0; i<lenName; i++ )
			{
				pos=InStr(killed,"/");
				if( pos>=0 )
					killed = Left( killed, pos ) $ " " $ Right( killed, lenName-pos-1 );
				else break;
			}
		}
		// Killer Name Filtering
		if( InStr(killerName,"/")>=0 ){
			lenName=Len(killerName);
			for(i=0; i<lenName; i++ )
			{
				pos=InStr(killerName,"/");
				if( pos>=0 )
					killerName = Left( killerName, pos ) $ " " $ Right( killerName, lenName-pos-1 );
				else break;
			}
		}
		// Map Name Filtering
		mapName=Level.Title;
		if( InStr(mapName,"/")>=0 ){
			lenName=Len(mapName);
			for(i=0; i<lenName; i++ )
			{
				pos=InStr(mapName,"/");
				if( pos>=0 )
					mapName = Left( mapName, pos ) $ " " $ Right( mapName, lenName-pos-1 );
				else break;
			}
		}
        //<- End filtering out things... AEon

        // AEon: Getting rid of stupid death messages! in log file! 
        //  "F/"<killed>"/"<killer>"/"<DamageType>"/"<Weapon ked>"/"<Weapon ker>"/"
        //		Suicides:			<killed>=<killer>
        //  	Environment Deaths: <killer>=<killed>
        //Bulding a nice datestamp that will be easy to parse->
		datestamp = ""$Level.Year;
		if( Level.Month < 10 ) zero = "0"; else zero = "";
                datestamp = datestamp $ zero $Level.Month;
		if( Level.Day < 10 ) zero = "0"; else zero = "";
	        datestamp = datestamp $ zero $Level.Day;
		if( Level.Hour < 10 ) zero = "0"; else zero = "";
	        datestamp = datestamp $ zero $Level.Hour;
		if( Level.Minute < 10 ) zero = "0"; else zero = "";
		datestamp = datestamp $ zero $Level.Minute;
		if( Level.Second < 10 ) zero = "0"; else zero = "";
		datestamp = datestamp $ zero $Level.Second;	//AEon<-

        //Frag log, Date & Time, Map Name,
		logmsg = "F/"$datestamp$"/"$Level.Title$"/";	//AEon


		if ( (Killer == Other) || (Killer == None) )
		{
			if( Killer==None ) logmsg = logmsg$killed$"/"$killed$"/";     //AEon enviro deaths->
			else		   logmsg = logmsg$killerName$"/"$killerName$"/"; //AEon suicide<-

			// suicide
			if ( LocalLog != None )
				LocalLog.LogSuicide(Other, damageType);
			if ( WorldLog != None )
				WorldLog.LogSuicide(Other, damageType);
			message = KillMessage(damageType, Other);
			BroadcastMessage(Other.PlayerReplicationInfo.PlayerName$message, false, 'DeathMessage');
		}
		else
		{
       		logmsg = logmsg$killed$"/"$killerName$"/";			//AEon

			if (Killer.Weapon != None)
			{
				KillerWeaponName = Killer.Weapon.ItemName;
				DeathMessage = Killer.Weapon.DeathMessage;
			}
			if (Other.Weapon != None)
				VictimWeaponName = Other.Weapon.ItemName;

			if ( LocalLog != None )
				LocalLog.LogKill(
						Killer.PlayerReplicationInfo.PlayerID,
						Other.PlayerReplicationInfo.PlayerID,
						KillerWeaponName,
						VictimWeaponName,
						damageType
				);
			if ( WorldLog != None )
				WorldLog.LogKill(
						Killer.PlayerReplicationInfo.PlayerID,
						Other.PlayerReplicationInfo.PlayerID,
						KillerWeaponName,
						VictimWeaponName,
						damageType
				);

// AEon moved up
//			killed = Other.PlayerReplicationInfo.PlayerName;
			if ( (DamageType == 'SpecialDamage') && (SpecialDamageString != "") )
			{
				message = ParseKillMessage(
					Killer.PlayerReplicationInfo.PlayerName,
					Other.PlayerReplicationInfo.PlayerName,
					KillerWeaponName,
					SpecialDamageString
				);
				BroadcastMessage(message, false, 'DeathMessage');
			}
			else if ( bClassicDeathmessages || (Killer.Weapon == None)
				|| ((DamageType != Killer.Weapon.MyDamageType) && (DamageType != Killer.Weapon.AltDamageType)) )
			{
				message = killer.KillMessage(damageType, Other);
				BroadcastMessage(killed$message, false, 'DeathMessage');
			} 
			else 
			{
				message = ParseKillMessage(
					Killer.PlayerReplicationInfo.PlayerName,
					Other.PlayerReplicationInfo.PlayerName,
					KillerWeaponName,
					DeathMessage
				);
				BroadcastMessage(message, false, 'DeathMessage');
			}
		}
   		logmsg = logmsg$damageType$"/"$		        	//AEon->
                 Other.Weapon$"/"$killer.Weapon$"/"$
                 Other.bAltFire$"/"$killer.bAltFire$"/"$
		         Other.Health$"/"$killer.Health$"/"$
        		 Other.SelectedItem$"/"$killer.SelectedItem$"/";
        log(logmsg);									//AEon<-
	}
	ScoreKill(killer, Other);

	// UnrealShare-DeathMatchGame
	// Monitor killed messages for fraglimit
	//	Super.Killed(killer, Other, damageType); //AEon commented out
	if ( (killer == None) || (Other == None) )
		return;
	if ( !bTeamGame && (FragLimit > 0) && (killer.PlayerReplicationInfo.Score >= FragLimit) )
		EndGame("fraglimit");

	if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
	{
		if ( killer.IsA('Bots') )
			Bots(killer).AdjustSkill(true);
		if ( Other.IsA('Bots') )
			Bots(Other).AdjustSkill(false);
	}

}

defaultproperties
{
}
