//-----------------------------------------------------------------------------
// Camera
//-----------------------------------------------------------------------------

#ifndef __CAMERA_H__
#define __CAMERA_H__

#include "frustum.h"

/**
 * Camera class.
 * The camera inheritate from the frustum class.
 * The camera rotation vector has default orientation equal to (90, -90, 0).
 * All rotations value given to camera should take care of this to have
 * valid orientations.
 */
class Camera : public Frustum
{
  public:
    Camera(void);
    ~Camera(void);
    
    void Init(float fov, float w, float h);
    void SetFov(float fov);
    float GetFov(void);

    void UpdateRotation(void);    /**< Updates the rotation matrix */
    void UpdatePosition(void);    /**< Updates the camera position */
    void UpdateViewport(void);    /**< Updates the camera viewport */
    void UpdateProjection(void);  /**< Updates the projection matrix */
    void UpdateFrustum(void);   /**< Updates the camera frustum */

    /**
     * Imports the parameters of another camera.
     */
    void ImportParams(Camera *cam);

    float pos[3];         /**< position */
    float rot[3];         /**< rotation (in order: pitch, yaw, roll) */

    float fov;            /**< fov in radians */
    float cos_fov;          /**< cos(fov) */
    float proj_ratio;       /**< projection ratio */

    float viewport_size;      /**< normalized viewport size */
    float viewport_width;     /**< maximum width of viewport */
    float viewport_height;      /**< maximum height of viewport */
    float viewport_left;      /**< left position of viewport */
    float viewport_top;       /**< top position of viewport */

    float viewsize;         /**< Viewport size */

    float rotation[9];        /**< precalculated 3x3 rotation matrix for applying movements */

    vec3_t forward;         /**< eyedir, and normal of the viewing z=0 plane */
    vec3_t right;         /**< right vector */
    vec3_t up;            /**< up vector */
    float eyedist;          /**< signed distance to the z=0 plane */

    bool inWater;         /**< camera is in water */
    float waterwidthdeform;     /**< Water width deformation */
    float waterheightdeform;    /**< Water height deformation */
    float waterdeformtimefactor;  /**< Water deformation scale */

    bool lockfrustum;       /**< locks the camera frustum */
};

#endif  /* __CAMERA_H__ */
