//-----------------------------------------------------------------------------
// Surface
//-----------------------------------------------------------------------------

#include "types.h"
#include "mem.h"
#include "console.h"
#include "system.h"

Surface::Surface(void)
{
  levels = 0;
  currentlevel = 0;
  indextype = -1;
  model = -1;
  framenum = 0;
  facetype = 0;
  shader = -1;
  lm_texnum = ~0;
  dist = 0;
  autosprite2_axis = 2;
  patch_cp[0] = patch_cp[1] = 0;
  memset(v_norm, 0, sizeof(vec3_t));
  memset(v_orig, 0, sizeof(vec3_t));
  memset(bbox, 0, sizeof(bboxf_t));
  effect = -1;
#if MODIF_FOG
  fogplane = NULL;
#else
  fog[0] = fog[1] = fog[2] = fog[3] = fog[4] = 0;
#endif
  firstvert = NULL;
  firstelem = NULL;
  numverts = NULL;
  numelems = NULL;
}

Surface::~Surface(void)
{
  if (firstvert || firstelem || numverts ||numelems) Shut();
}

void Surface::Init(int lvl)
{
  levels = (lvl>1)?lvl:1;

  if (firstvert) cake_free(firstvert);
  if (firstelem) cake_free(firstelem);
  if (numverts) cake_free(numverts);
  if (numelems) cake_free(numelems);
  
  if (!(firstvert = (vertex_t**) cake_malloc(levels*sizeof(vertex_t*), "Surface::Init.firstvert")))
    ThrowException(ALLOCATION_ERROR, "Surface::Init.firstvert");
  if (!(firstelem = (int**) cake_malloc(levels*sizeof(int*), "Surface::Init.firstelem")))
    ThrowException(ALLOCATION_ERROR, "Surface::Init.firstelem");
  if (!(numverts = (int*) cake_malloc(levels*sizeof(int), "Surface::Init.numverts")))
    ThrowException(ALLOCATION_ERROR, "Surface::Init.numverts");
  if (!(numelems = (int*) cake_malloc(levels*sizeof(int), "Surface::Init.numelems")))
    ThrowException(ALLOCATION_ERROR, "Surface::Init.numelems");

  // Initialize the levels
  for (int i = 0; i < levels; ++i)
  {
    firstvert[i] = NULL;
    firstelem[i] = NULL;
    numverts[i] = 0;
    numelems[i] = 0;
  }
}

void Surface::Shut(void)
{
  int i;
  
  if (firstvert)
  {
    for (i = 0; i < levels; ++i) firstvert[i] = NULL;
    cake_free(firstvert);
  }
  
  if (numverts) cake_free(numverts);

  if (firstelem)
  {
    for (i = 0; i < levels; ++i) firstelem[i] = NULL;
    cake_free(firstelem);
  }

  if (numelems) cake_free(numelems);

  firstvert = NULL;
  firstelem = NULL;
  numverts = NULL;
  numelems = NULL;
}
