//-----------------------------------------------------------------------------
// Texture
//-----------------------------------------------------------------------------

#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#include "files.h"

/**
 * Adjust color, currently only overbright is used.
 */
void AdjustColor(texinfo *t, float overbright, float gamma, float lightness);

/**
 * Given a texrefs, loads the texture, sends it to the driver and delete it.
 * @param tr the texture reference to load.
 */
void LoadTexture(TexRefs *tr);

/**
 * Load a TGA.
 */
void TGA_Decode(VFile *vf, texinfo *tex);

/**
 * Load a JPG.
 */
void JPG_Decode(VFile *vf, texinfo *tex);

/**
 * Load a WAL.
 */
void WAL_Decode(VFile *vf, texinfo *tex);

/**
 * Loads the default texture.
 * @param t The destination texture.
 * @todo Use a better default texture, this looks jerky
 */
void LoadDefaultTex(texinfo *t);

/**
 * Flips a texture vertically.
 * @param tex The texture to be flipped.
 */
void FlipTexture(texinfo *tex);

/**
 * Texture manager.
 * The texture manager provides all mechanisms to load and create textures. The
 * manager supports following texture types:
 * - TGA (8, 16, 24, 32 bits)
 * - JPG
 * - WAL
 * @todo Instead of using a fixed size array, we could use a grow array,
 *       note that we need inmediate aleatory acces.
 * @bug When a shader or a texture is not found, the engine crashes during map
 *      unload. Try changing a shader name (required by the map) and launch the
 *      engine.
 */
class TextureManager
{
  public:

    TextureManager(int num = 1024);
    ~TextureManager(void);

    /**
     * Increases a texinfo count, if already loaded, or reserves it if not loaded.
     */
    texinfo *AddTexinfo(const char *name, int flags);
    
    /**
     * Decreases count of the given texinfo.
     * @param info the texinfo to decrement
     */
    void DeleteTexinfo(texinfo *info);

    /**
     * Reset all the counters.
     */
    void ResetAll(void);

    /**
     * Loads unloaded textures, deletes unreferenced textures.
     */
    void Update(void);

  private:

    TexRefs *texrefs;
    int max_refs;
    int num_refs;
};

#endif /* __TEXTURE_H__ */
