/*
 * $Revision: 3433 $
 *
 * last checkin:
 *   $Author: gutwenger $
 *   $Date: 2013-04-22 13:44:53 +0200 (Mo, 22. Apr 2013) $
 ***************************************************************/

/** \file
 * \brief Uses Fruchtermann Rheingold and Fast Multipole Embedder for faster and better FR results.
 *
 * \author Gereon Bartel
 *
 * \par License:
 * This file is part of the Open Graph Drawing Framework (OGDF).
 *
 * \par
 * Copyright (C)<br>
 * See README.txt in the root directory of the OGDF installation for details.
 *
 * \par
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * Version 2 or 3 as published by the Free Software Foundation;
 * see the file LICENSE.txt included in the packaging of this file
 * for details.
 *
 * \par
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * \par
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * \see  http://www.gnu.org/copyleft/gpl.html
 ***************************************************************/

#ifdef _MSC_VER
#pragma once
#endif

#ifndef OGDF_MIXED_FORCE_LAYOUT_H
#define OGDF_MIXED_FORCE_LAYOUT_H

#include <ogdf/module/LayoutModule.h>
#include <ogdf/internal/energybased/MultilevelGraph.h>

namespace ogdf {

class OGDF_EXPORT MixedForceLayout : public LayoutModule
{
public:

	MixedForceLayout();

	void call(GraphAttributes &GA);
	void call(GraphAttributes &GA, GraphConstraints & GC) { call(GA); }
	void call(MultilevelGraph &MLG);

private:

	LayoutModule * m_FR;
	LayoutModule * m_FME;

};

} // namespace ogdf

#endif
