# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libvorbis.

FIND_PATH(VORBIS_INCLUDE_DIR vorbis/codec.h)

SET(VORBIS_NAMES ${VORBIS_NAMES} vorbis libvorbis)
FIND_LIBRARY(VORBIS_LIBRARY NAMES ${VORBIS_NAMES} PATH)

IF(VORBIS_INCLUDE_DIR AND VORBIS_LIBRARY)
	SET(VORBIS_FOUND TRUE)
ENDIF(VORBIS_INCLUDE_DIR AND VORBIS_LIBRARY)

IF(VORBIS_FOUND)
	IF(NOT Vorbis_FIND_QUIETLY)
		MESSAGE(STATUS "Found Vorbis: ${VORBIS_LIBRARY}")
	ENDIF (NOT Vorbis_FIND_QUIETLY)
ELSE(VORBIS_FOUND)
	IF(Vorbis_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find vorbis")
	ENDIF(Vorbis_FIND_REQUIRED)
ENDIF (VORBIS_FOUND)
