/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)AToolBar.java	1.12 06/27/07
 */ 

package com.sun.messaging.jmq.admin.apps.console;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.ImageIcon;


/** 
 * This class is the toolbar class used in the admin console
 * application.
 * <P>
 *
 * All the items created here are done via Actions and
 * they are controlled by the ActionManager class.
 *
 */
public class AToolBar extends JToolBar  {

    private ConsoleObj		conObj = null;
    private ActionManager	actionMgr;
    private boolean		displayIcons,
				displayText,
				displayToolTip;

    JButton		addButton,
			deleteButton,
			propsButton,
			shutdownButton,
			restartButton,
			connectButton,
			disconnectButton,
			queryButton,
			pauseButton,
			resumeButton,
			refreshButton;

    /**
     * Creates a toolbar for the admin console application.
     * <P>
     * The toolbar created will:
     * <UL>
     * <LI>Display icons
     * <LI>Not display text labels
     * <LI>Display tooltip text
     * </UL>
     *
     * @param actionMgr		The ActionManager.
     */
    public AToolBar(ActionManager actionMgr) {
	this(actionMgr, true, false, true);
    } 

    /**
     * Creates a toolbar for the admin console application.
     *
     * @param actionMgr		The ActionManager.
     * @param displayIcons	Flag to indicate whether the
     *				toolbar buttons should display icons
     *				for the action if available.
     * @param displayText	Flag to indicate whether the
     *				toolbar buttons should display their 
     *				text labels for the action if available.
     * @param displayToolTip	Flag to indicate whether the
     *				toolbar buttons should display their 
     *				tooltip text for the action if available.
     */
    public AToolBar(ActionManager actionMgr,
			boolean displayIcons,
			boolean displayText,
			boolean displayToolTip) {
	super();

	this.actionMgr = actionMgr;
	this.displayIcons = displayIcons;
	this.displayText = displayText;
	this.displayToolTip = displayToolTip;

	initGui();
    } 

    /**
     * Set the <EM>current</EM> console object.
     * The purpose for doing this is to determine
     * what icons/tooltips to display for the buttons.
     *
     * @param conObj	Console object.
     */
    public void setConsoleObj(ConsoleObj conObj)  {
	this.conObj = conObj;
	setLabels();
	setIcons();
    }


    private void initGui()  {
	setFloatable(false);

	/*
	putClientProperty("JToolBar.isRollover", Boolean.TRUE);
	*/

	addButton = addOneAction(actionMgr.getAction(ActionManager.ADD));
	deleteButton = addOneAction(actionMgr.getAction(ActionManager.DELETE));
	propsButton = addOneAction(actionMgr.getAction(ActionManager.PROPERTIES));

	addSeparator();
	connectButton = addOneAction(actionMgr.getAction(ActionManager.CONNECT));
	disconnectButton = addOneAction(actionMgr.getAction(ActionManager.DISCONNECT));

	addSeparator();
	queryButton = addOneAction(actionMgr.getAction(ActionManager.QUERY_BROKER));
	pauseButton = addOneAction(actionMgr.getAction(ActionManager.PAUSE));
	resumeButton = addOneAction(actionMgr.getAction(ActionManager.RESUME));
	restartButton = addOneAction(actionMgr.getAction(ActionManager.RESTART));
	shutdownButton = addOneAction(actionMgr.getAction(ActionManager.SHUTDOWN));

	addSeparator();
	refreshButton = addOneAction(actionMgr.getAction(ActionManager.REFRESH));
    }

    private JButton addOneAction(Action a)  {
	JButton jb;

	jb = add(a);

	if (!displayIcons)  {
	    jb.setIcon(null);
	}
	if (!displayText)  {
	    jb.setText("");
	}
	if (displayToolTip)  {
	    jb.setToolTipText((String)a.getValue(a.NAME));
	}

	return (jb);
    }

    /*
     * Set tooltips on buttons based on current console object.
     */
    private void setLabels()  {
	if (conObj == null)  {
	    return;
	}

	checkAndSetLabel(ActionManager.ADD, addButton);
	checkAndSetLabel(ActionManager.PAUSE, pauseButton);
	checkAndSetLabel(ActionManager.RESUME, resumeButton);
	checkAndSetLabel(ActionManager.CONNECT, connectButton);
	checkAndSetLabel(ActionManager.DISCONNECT, disconnectButton);
    }

    private void checkAndSetLabel(int actionFlag, JButton button)  {
	String label;

	label = conObj.getActionLabel(actionFlag, false);
	if (label != null)  {
	    if (displayToolTip)  {
	        button.setToolTipText(label);
	    }

	    if (displayText)  {
	        button.setText(label);
	    }
	}
    }

    /*
     * Set icons on buttons based on current console object.
     */
    private void setIcons()  {
	if (conObj == null)  {
	    return;
	}

	checkAndSetIcon(ActionManager.CONNECT, connectButton);
	checkAndSetIcon(ActionManager.DISCONNECT, disconnectButton);
    }

    private void checkAndSetIcon(int actionFlag, JButton button)  {
	ImageIcon icon;

	icon = conObj.getActionIcon(actionFlag);
	if (icon != null)  {
	    /*
	     * 'Clear' out disabled icon.
	     * If this is not done, the disabled icon will remain what it was
	     * prior to the setIcon() below.
	     *
	     * This may be related to bug:
	     * 4117779 - JLabel.setIcon() has no effect on default disabled 
	     *			icon of a JLabel
	     */
	    button.setDisabledIcon(null);

	    button.setIcon(icon);
	}
    }

}
