/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * InstallerResources.java
 */ 

package com.sun.messaging.jmq.installer.resources;

import java.util.ResourceBundle;
import java.util.Locale;
import com.sun.messaging.jmq.util.MQResourceBundle;

/**
 * This class wraps a PropertyResourceBundle, and provides constants
 * to use as message keys. The reason we use constants for the message
 * keys is to provide some compile time checking when the key is used
 * in the source.
 */

public class InstallerResources extends MQResourceBundle {

    private static InstallerResources resources = null;

    public static InstallerResources getResources() {
        return getResources(null);
    }

    public static InstallerResources getResources(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }

        if (resources == null || !locale.equals(resources.getLocale())) {
            ResourceBundle prb =
                ResourceBundle.getBundle(
                "com.sun.messaging.jmq.installer.resources.InstallerResources",
                locale);
            resources = new InstallerResources(prb);
        }

	return resources;
    }

    private InstallerResources(ResourceBundle rb) {
        super(rb);
    }


    /***************** Start of message key constants *******************
     * We use numeric values as the keys because the Broker has a requirement
     * that each error message have an associated error code (for 
     * documentation purposes). We use numeric Strings instead of primitive
     * integers because that is what ListResourceBundles support. We could
     * write our own ResourceBundle to support integer keys, but since
     * we'd just be converting them back to strings (to display them)
     * it's unclear if that would be a big win. Also the performance of
     * ListResourceBundles under Java 2 is pretty good.
     * 
     *
     * Note To Translators: Do not copy these message key String constants
     * into the locale specific resource bundles. They are only required
     * in this default resource bundle.
     *
     * Note to JMQ engineers: Remove the sample entries e.g. I_SAMPLE_MESSAGE
     * when you add entries for that category.
     */

    // 0-999     Miscellaneous messages
    final public static String M_SAMPLE_MESSAGE		= "I0000";

    // 1000-1999 Informational Messages
    final public static String I_SAMPLE_INFO 		= "I1000";

    // 2000-2999 Warning Messages
    final public static String W_SAMPLE_WARN		= "I2000";

    // 3000-3999 Error Messages
    final public static String E_SAMPLE_ERROR		= "I3000";

    // 4000-4999 Exception Messages
    final public static String X_SAMPLE_EXCEPTION	= "I4000";

    // 5000-5999 Question Messages
    final public static String Q_SAMPLE_QUESTION	= "I5000";

    /***************** End of message key constants *******************/
}
