/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BOOLEANHANDLER_H
#define BOOLEANHANDLER_H


#include <qobject.h>
#include "general/drawingfield.h"
#include "elements/pointarray.h"

/**
@author Juergen Thies
*/

class Bool_Engine;
class layout;

enum GroupType 
{ 
   GROUP_A, /* !< to set Group A for polygons */
   GROUP_B  /* !< to set Group B for polygons */
};
#define GROUPTYPE
//! accessing the boolean utility
/*!
Via this class it is possible to access the boolean utility.
@code
layout->drawing->currentCell->fSelect(rect1);<br>
layout->booleanTool->setA();<br>
layout->drawing->currentCell->fSelect(rect2);<br>
layout->booleanTool->setB();<br>
layout->drawing->activeLayer=1;<br>
layout->booleanTool->aPlusB();<br>
@endcode
*/
class booleanHandler : public QObject
{
Q_OBJECT
private:
   drawingField *drawing;
   layout *l;
   bool validA,validB;
   Bool_Engine *engine;
public:
    booleanHandler(drawingField *drawing,layout *la);
//! boolean handler
/*!
Create a boolean class to perform boolean operations
@nomacro
*/    
    booleanHandler(drawingField *drawing);
    booleanHandler();
    ~booleanHandler();
   void init();
public slots:
   void setAGui();
   void setBGui();
   void setLayerAGui();
   void setLayerBGui();
   void aPlusBGui();
   void aMinusBGui();
   void bMinusAGui();
   void aMultiBGui();
   void aExorBGui();
   void mergeSelectToActiveLayer();
   
public:
	void setA(pointArray *);
	void setB(pointArray *);
	void setA(element *);
	void setB(element *);
	//pointArray getAMinusB();
	QList<pointArray> getAMinusB();
	QList<pointArray> getAPlusB();
	QList<pointArray> getBMinusA();
	QList<pointArray> getAMultiB();
	QList<pointArray> getAExorB();
//! merge select
/*!
Selected elements will be merged and added to layer
*/
   void mergeSelect(int layer);
//! set A elements
/*!
Selected elements will be added to the group A. All elements will be deselected.
*/
   void setA();
//! set B elements
/*!
Selected elements will be added to the group B. All elements will be deselected.
*/
   void setB();
//! A+B
/*!
The sum of A and B is added on the active Layer. 
*/
   void aPlusB();
//! A-B
/*!
The difference of A and B is added on the active Layer. 
*/
   void aMinusB();
//! B-A
/*!
The difference of B and A is added on the active Layer. 
*/
   void bMinusA();
//! A*B
/*!
The intersection of A and B is added on the active Layer. 
*/
   void aMultiB();
//! A eor B
/*!
The eor of A and B is added on the active Layer. 
*/
   void aExorB();  
//! perform A+B
/*!
The operation A and B is performed. Use the result with getResultingPolygon(), setResultToA() or setResultToB().
*/
   void performAPlusB();
//! perform A-B
/*!
The operation A minus B is performed. Use the result with getResultingPolygon(), setResultToA() or setResultToB().
*/
   void performAMinusB();
//! perform B-A
/*!
The operation B minus A is performed. Use the result with getResultingPolygon(), setResultToA() or setResultToB().
*/
   void performBMinusA();
//! perform A+B
/*!
The intersection of A nad B is performed. Use the result with getResultingPolygon(), setResultToA() or setResultToB().
*/
   void performAMultiB();
//! perform A exor B
/*!
The operation A exclusive or B is performed. Use the result with getResultingPolygon(), setResultToA() or setResultToB().
*/
   void performAEorB();
//! perform A exor B
/*!
@return a pointarray of the result of the last boolean operation. If the boolean operation result in more polygons, consequent call will return the next pointarray. A empty pointarray is return, if no more pointarray are available.
*/
   pointArray getResultingPolygon();
//! result to a
/*!
The result of the last operation, is set up A for a following operation
*/
   void setResultToA();
//! result to b
/*!
The result of the last operation, is set up B for a following operation
*/
   void setResultToB();
//! add to a
/*!
adds the polygon to a.
*/
   void addA(pointArray pointarray);
//! add to b
/*!
adds the polygon to b.
*/
   void addB(pointArray pointarray);
//! add layer to A
/*!
adds all element including hierarchical element on layer in the current cell to a.
*/
   void addLayerA(int layer);
//! add layer to B
/*!
adds all element including hierarchical element on layer in the current cell to b.
*/
   void addLayerB(int layer);
   QList<pointArray> resultingPointArrays();
   void ignoreB(){validB=true;};
private:
   void result(); 
   bool check();
   void add(GroupType g,pointArray *p);
   void add(GroupType g, strans trans, cell *c, int layer);
};

#endif
