/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "boolonlayer.h"
#include "general/userunitsvalidator.h"
#include "elements/element.h"

boolOnLayer::boolOnLayer(QWidget*)
:boolOnLayerDialog()
{
setupUi(this);
layerA->setMaximum(layersMax-1);
layerB->setMaximum(layersMax-1);
layerResult->setMaximum(layersMax-1);
 frames->hide();
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
connect(layerA,SIGNAL(valueChanged(int)),this,SLOT(setLayerName1(int)));
connect(layerB,SIGNAL(valueChanged(int)),this,SLOT(setLayerName2(int)));
connect(layerResult,SIGNAL(valueChanged(int)),this,SLOT(setLayerName3(int)));
layerA->setValue(1);
layerB->setValue(2);
layerResult->setValue(3);
setModal(true);
}

boolOnLayer::~boolOnLayer()
{
}

void boolOnLayer::setLayerName1(int i){
if (i>=0) layerAName->setText(layers::num[i].name);
}
void boolOnLayer::setLayerName2(int i){
if (i>=0) layerBName->setText(layers::num[i].name);
}
void boolOnLayer::setLayerName3(int i){
if (i>=0) layerResultName->setText(layers::num[i].name);
}

void boolOnLayer::displayAll(){
  frames->show();
  fullDisplay->hide();
}

/*$SPECIALIZATION$*/
bool boolOnLayer::dialog( int *lA, int *lB,int *lResult,QString *s, int *nx,int *ny) {

boolOnLayer d;
  d.layerResult->setValue(*lResult);
  // d.boolOperation->
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	*lA=d.layerA->value();
	*lB=d.layerB->value();
	*s = d.boolOperation->currentText();
	*nx=d.nx->value();
	*ny=d.ny->value();
	*lResult=d.layerResult->value();
	return true;
   }
  return false;
}


