/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "defines.h"
#include "helpwindow.h"
#include <QTextBrowser>
#include <QUrl>
#include "general/setup.h"
#include "widgets/mousewidget.h"
#include <QKeySequence>
#include <QDesktopServices>
#ifdef FULL_VERSION
#include "license/license.h"
#endif



/**
@author Juergen Thies
*/
using namespace Ui;
helpWindow::helpWindow(QWidget* )
: helpWindowDialog()
{ 
  setupUi(this);
  //updateUrl();
  setWindowIcon(QIcon(":/layoutIcon"));
  helpBrowser->setOpenExternalLinks(true);
}

helpWindow::~helpWindow()
{
}

QString helpWindow::getMenuname(helpText mode){
QString s="";
switch (mode) {
#include "autogen/menuname.cpp"
  case clear: break;
  case setSubfunctionHelp:   break;
  case ungroupHelp: break;
  case view3dHelp:  break;
}
return s;
}

QKeySequence helpWindow::getShortKey(helpText mode){
switch (mode) {
#include "autogen/shortkey.cpp"
  case clear: break;
  case setSubfunctionHelp:   break;
  case ungroupHelp: break;
  case view3dHelp:  break;
}
return QKeySequence();
}

QIcon helpWindow::getIcon(helpText mode){
switch (mode) {
#include "autogen/icon.cpp"
  case clear: break;
  case setSubfunctionHelp:   break;
  case ungroupHelp: break;
  case view3dHelp:  break;
}
return QIcon();
}

QString helpWindow::getWhatsthis(helpText mode){
QString s="";
switch (mode) {
#include "autogen/whatsthis.cpp"
  case clear: break;
  case setSubfunctionHelp:   break;
  case ungroupHelp: break;
  case view3dHelp:  break;
}
return s;
}

int helpWindow::getMode(helpText mode){
switch (mode) {
#include "autogen/modes.cpp"
 default:
	return -1;
	break;
}
return -1;
}

void helpWindow::showHelp(){
  setUrl("LayoutEditor");
  
  //updateUrl();

}

void helpWindow::showHelp(QString name){
  if (name.size()==0) {showHelp();return;}
  name[0]=name[0].toUpper();
  for (int i=0;i<name.size()-1;i++){
    if (name[i]==QChar(32)) name[i+1]=name[i+1].toUpper();
  }
  name.remove(".");
  name.remove("/");
  name.remove(":");
  name.remove(" ");
  name.remove("\\");
  setUrl(name);
}
 
void helpWindow::showHelp(helpText mode){
  
  
QString url="";
switch (mode) {
#include "autogen/showhelp.cpp"
  case view3dHelp:  break;
  case clear: break;
  case setSubfunctionHelp:   break;
  case ungroupHelp: break;


// ungebraucht:
//      url="macro.html#techmacro";
//      url="macro.html#viewmacro";
//      url="help.html#help";
//      url="help.html#about";
 }
 showHelp(url);
}


void helpWindow::showModeHelp(int mode){
 QString url;
  switch (mode){
#include "autogen/showmodehelp.cpp"
  }
 showHelp(url);
}

/*
void helpWindow::updateUrl(){

#ifdef FULL_VERSION
  if (license::licenseLevel()>=2) {
  url=url.fromLocalFile( setup::documentationDirectory+"/index.html" );
  if (QDesktopServices::openUrl(url)) return;
  if (url.isValid()) {
	helpBrowser->setSource(url);
	show();
	}
  else 
#endif
	{
	QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/index.html"));
	//helpBrowser->setPlainText(tr("Helppages not found !!!"));
	}
#ifdef FULL_VERSION
  }
 else  
	QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/index.html"));
#endif
  
}*/

void helpWindow::setUrl(QString url_){
 QString url2="wiki/";
 /*if (setup::currentLang!="en"){
   QString url3=url2+setup::languageToLong(setup::currentLang)+"/";
   QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/"+url3+url_));
 }*/
 if (QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/"+url2+url_))) return;
  
#ifdef FULL_VERSION
 if (license::licenseLevel()>=2){
  if (setup::documentationDirectory=="") {
		QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/functions/"+url_));
		return;
		}
  if (url_.contains("#")){
    int i=url_.indexOf("#");
    QString h=url_.left(i);
	QString h1=url_.mid(i+1);
	i=h.lastIndexOf(".");
	QString h2=h.left(i);
	QString h3=h.mid(i);
	url=url.fromLocalFile( setup::documentationDirectory+"/functions/"+h2+"_"+h1+h3 );
	if (QDesktopServices::openUrl(url)) return;
    url=url.fromLocalFile( setup::documentationDirectory+"/functions/"+h );
   //printf("1:%s, %s\n",url.errorString ().toAscii().data(),url_.toAscii().data());
    if (url.isValid()&&(!url.isEmpty())) {
	helpBrowser->setSource(url);
	helpBrowser->scrollToAnchor(h1);
	}
    else  {
/*	url=url.fromLocalFile( setup::documentationDirectory+"/index.html" );
  	if (url.isValid()) {helpBrowser->setSource(url);}
  	else {*/
		QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/functions/"+url_));
		return;
		//}
	}
    }
  else {
    url=url.fromLocalFile( setup::documentationDirectory+"/functions/"+url_ );
    //printf("2:%s\n",url.errorString ().toAscii().data());
    if (QDesktopServices::openUrl(url)) return;
    if (url.isValid()&&(!url.isEmpty())) {helpBrowser->setSource(url);}
    else  {
/*	url=url.fromLocalFile( setup::documentationDirectory+"/index.html" );
  	if (url.isValid()) {helpBrowser->setSource(url);}
  	else {*/
		QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/functions/"+url_));
		return;
//		}
	}
    }
 }
#endif
 if (helpBrowser->toPlainText ()=="") {
	QDesktopServices::openUrl(QUrl("http://www.layouteditor.net/functions/"+url_));
	return;
	}
 show();
}




