/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DRC_H
#define DRC_H
#include <QListWidgetItem>
#include <qobject.h>
#include <qstring.h>
#include "general/drawingfield.h"
#include "widgets/mainwindow.h"
#include "drc/drcregionmode.h"
class drawingField;
class booleanHandler;
class layout;
class drcDock;
class elementIterator;
/**
@author Juergen Thies
*/
enum drcAreaType {drcCell,drcRegion,drcView};
class drcErrorItem {
  public:
  drcErrorItem(QString);
  drcErrorItem(QString,helpText type,double val);
  QString rule;
  helpText check;
  int status;
  QPoint pos1,pos2;
  double value;
};

//! Design Rule Checker
/*!
*/
class drc : public drcRegionMode
{
Q_OBJECT
public:
    //drc();
    drc(drawingField *drawing,layout *la);
    ~drc();
    drawingField *d;
    layout *l;
    booleanHandler *booleanTool;
//! error layer
    int errorLayer;
//! error count
    int errorCount; //in all check on this cell
//! errors
    int error; //in last check
//! ruleName
    QString ruleName;
//! result
    QString result;
public slots:
//! set error layer
    void setErrorLayerToActiveLayer(){
		errorLayer=d->activeLayer;
		d->macroAdd("layout->drcTool->setErrorLayerToActiveLayer();");}
    void setRuleName(QString s);
//! get reports
    QString getReport();
//! no Element 
    void noElementOnLayer(int layer);
//! no Element on active
    void noElementOnActiveLayer();
//! no Path 
    void noPathOnLayer(int layer);
//! no Path on active
    void noPathOnActiveLayer();
//! no Box Element 
    void noBoxOnLayer(int layer);
//! no Box on active
    void noBoxOnActiveLayer();
//! no Polygons 
    void noPolygonOnLayer(int layer);
//! no Polygons on active
    void noPolygonOnActiveLayer();
//! no Text 
    void noTextOnLayer(int layer);
//! no Text on active
    void noTextOnActiveLayer();
//! show reports
    void showReport();
//! minimum Distance
    void minimumDistance(int distance,int layer1, int layer2);
//! minimum Distance or Overlap
    void minimumDistanceOrOverlap(int distance,int layer1, int layer2,bool mode=true);
//! minimum Size
    void minimumSize(int size,int layer, bool mergeBefore=false, bool sharpAngles=true);
//! minimum Overlap
    void minimumOverlap(int overlap,int layer1, int layer2);
//! inside with Distance
    void inside(int distance,int insideLayer, int layer1, int layer2=-1, int layer3=-1);
//! Overlapping elements
    void overlapingElements(int layer);
//! layer combination
    void layerCombination(int layer1,int layer2, int layer3=-1,int layer4=-1, int layer5=-1);
//! Overlapping elements on active
    void overlapingElementsOnActiveLayer();
//! Minimum element Distance
    void minimumElementDistance(int distance,int layer,bool mergeBefore=false);
//! Minimum overlap element Distance
    void minimumOverlapDistance(int distance,int layer1,int layer2);
//! Minimum Enclose
    void minimumEnclosure(int distance,int layer1,int layer2);
//! Minimum element Distance on active
    void minimumElementDistanceOnActiveLayer(int distance);
//! no Circle on active
    void noCircleOnActiveLayer();
//! only Circle on active
    void onlyCircleOnActiveLayer();
//! no Circle on Layer
    void noCircleOnLayer(int layer);
//! only Circle on active
    void onlyCircleOnLayer(int layer);
//! onGrid
    void onGrid(int grid,int layer);
//! no Holes on Layer
    void noHolesOnLayer(int layer,bool mergeBefore=false);
//! no Minimun Notch on Layer
    void minimumNotchOnLayer(int notchsize, int layer, bool mergeBefore=false,bool testSlots=false);
//! Minimum Perimeter on Layer
    void minimumPerimeterOnLayer(int layer, int perimetervalue ,bool mergeBefore=false);
//! Maximum Perimeter on Layer
    void maximumPerimeterOnLayer(int layer, int perimeter,bool mergeBefore=false);
//! Minimum Area on Layer
    void minimumAreaOnLayer(int layer, double areavalue ,bool mergeBefore=false);
//! Maximum Area on Layer
    void maximumAreaOnLayer(int layer, double areavalue ,bool mergeBefore=false);
//! check 90 Angle on Layer
    void angle90OnLayer(int layer,bool mergeBefore=false);
//! check 45 Angle on Layer
    void angle45OnLayer(int layer,bool mergeBefore=false);
//! maximum Angle on Layer
    void maximumAngleOnLayer(double anglevalue, int layer, bool mergeBefore=false);
//! maximum Dimension on Layer
    void maximumDimensionOnLayer(int length,int width, int layer, bool mergeBefore=false);
//! minimum Dimension on Layer
    void minimumDimensionOnLayer(int length,int width, int layer, bool mergeBefore=false);
//! set drc area to hole cell
    void setCheckCell();
//! set drc area to region  
    void setCheckRegion(QPoint,QPoint);
//! set drc area to current view
    void setCheckView();
//! set illustration list
    void setList(bool);
//! set illustration graphical
    void setGraphical(bool);
//! save violations
    void saveViolationList(QString filename);
//! load violation list
    void loadViolationList(QString filename);
//! add violation to list
    void addViolation(QString name,double value, QPoint p1, QPoint p2, int type=0,int status=0);
//! clear violation list
    void clearViolationView();
//! set drc region mode  
    void setRegionMode();
//! dimension check
    void dimensionOnLayer(int lengthMin,int lengthMax,int widthMin,int widthMax, int layer, bool mergeBefore=false);

 //gui slots:
    void noCircleOnActiveLayerGui();
    void onlyCircleOnActiveLayerGui();
    void noElementOnActiveLayerGui();
    void noPathOnActiveLayerGui();
    void noBoxOnActiveLayerGui();
    void noPolygonOnActiveLayerGui();
    void noTextOnActiveLayerGui();
    void overlapingElementsOnActiveLayerGui();

    void checkAreaChangedGui();
    void illustrationChangedGui(int);
    void toggleViolationView();
    void saveViolationList();
    void loadViolationList();
    void violationListClicked( QListWidgetItem * item);
    void violationListDblClicked( QListWidgetItem * item);
    
    void updateGui();
    void updateDock();
    void showDock();
  
  signals:
    void updateDockRequired();
public:  
    void initDock();
    drcDock *dock;
private:
    //setup
    drcAreaType drcArea;
    QRect region,view;
    bool drcToList,drcToCell,updateDockRunning,updateDockRetrigger;
  
    bool record;
    int oldActiveLayer;
    int oldMode;
    double oldScale;
    int oldX,oldY;
    helpText drcType;
    
    cell *checkCell, *workCell;
    QString orginalCellname;
    QString workCellname;
    QList<cell*> helpCells;
    
    //void prepareCheck(bool copyMode=true);
    //void completeCheck();
    void prepareCheck(helpText drctype);
    void completeCheck(bool useWorkCell,bool reportWorkCell);

    elementList *reportedErrors;
    int countErrors;
    
    QTime messageTimer;
    uint messageCounter;
    inline void message(bool end=false);
    
    void toBoolean(int layer, bool set,cell *c, bool useDrcArea=false);
    void fromBoolean(int layer, cell *c);
    //void flatLayerCopy(int layer, cell *source, cell *dest);
    void moveCellRefs(cell *source, cell *dest);
    void moveLayer(int layer, cell *source, cell *dest);
    void mergeLayer(int layer, cell *source, cell *dest);
    void makeHierarchie(cell *source);
    void setDrcRegion(elementIterator *);
    
    QList<drcErrorItem> violationList;
    QList<QListWidgetItem*> violationListItems;
public:
    void reportError(QPoint,QPoint, double value);
    void reportError(QPoint, double value);
    void reportErrorDeg(QPoint, double value);
    void reportError(element *);
    //void addError();

};

#endif
