/***************************************************************************
 *   Copyright (C) 2011 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "drc/drcregionmode.h"
#include "general/drawingfield.h"
#include "general/basemode.h"
#include "general/paintpixmapthread.h"
#include "elements/box.h"
#include "elements/polygon.h"
#include "elements/path.h"
#include <QMessageBox>

drcRegionMode::drcRegionMode (drawingField *dr): baseMode(dr){
 d=dr;
}

drcRegionMode::~drcRegionMode(){
}

void drcRegionMode::init(){
d->modestep=0;
}

void drcRegionMode::paintAlways(QPainter *paint){

}

void drcRegionMode::paintImage(QPainter *paint){
  if (d->modestep!=0){
		paint->drawRect(d->makeRectPaintEvent(d->mouseDrawingPos,QPoint(region.left(),region.bottom())));
		}
}

void drcRegionMode::paintCell(QPainter *paint){



}
void drcRegionMode::prepareOutput(){
  emit d->mousePosChange(d->mouseDrawingPos);
}
void drcRegionMode::mousePressed(){
  if ((d->mouseButton==Qt::LeftButton)&&(d->mouseModifiers==Qt::NoModifier)) {
    if (d->modestep==0){
      region.setLeft(d->mouseDrawingPos.x());
      region.setBottom(d->mouseDrawingPos.y());
      d->modestep=1;
      }
    else if (d->modestep==1){
      region.setRight(d->mouseDrawingPos.x());
      region.setTop(d->mouseDrawingPos.y());
      d->modestep=0;
      emit finished(QPoint(region.left(),region.bottom()),QPoint(region.right(),region.top()));
      d->setDefaultMode();
      }
    else  d->setDefaultMode();
  }
}


