/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "elementlist.h"
#include "cell.h"

elementList::elementList()
{
nextElement=NULL;
thisElement=NULL;
}


elementList::~elementList()
{
}

qint16 elementList::getDefaultLayer(){
	qint16 h=-1;
	if (thisElement!=NULL) {
		if (thisElement->isBox()) h=thisElement->getDefautLayer();
		else if (thisElement->isPolygon()) h=thisElement->getDefautLayer();
		else if (thisElement->isPath()) h=thisElement->getDefautLayer();
		if (h>=0) return h;
		}
	if (nextElement!=NULL) return nextElement->getDefaultLayer();
	if (thisElement->isCellref()){
		cell *c=thisElement->depend();
		if (c!=NULL) h=c->getDefaultLayer();
		}
	if (h>=0) return h;
	if (thisElement->isCellrefArray()){
		cell *c=thisElement->depend();
		if (c!=NULL) h=c->getDefaultLayer();
		}
	if (h>=0) return h;
	return -1;
	}
