/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYERTRANSLATOR_H
#define LAYERTRANSLATOR_H
#include "general/layers.h"
/**
@author Juergen Thies
*/


//! layer translator class
/*!
This class is used for the layer mapping functions is the classes @link "mapLayer%Class drawingField;drawingField" and @link "mapLayer%Class cell;cell"<br>
<br>Example:
@code
layerTranslator t;<br>
t.mapLayer(18,19);<br>
t.mapLayer(19,18);<br>
layout->drawing->mapLayer(&t);<br>
@endcode 
*/
class layerTranslator{
public:
//! layer tranlator
/*!
creates a layertranlator
@nomacro
*/
    layerTranslator();

    ~layerTranslator();
//! map layer
/*!
sets a mapping of layer from to Layer to
*/
	void mapLayer(int from, int to);
//! map all
/*!
sets the mapping of all layer to to
*/
	void mapAll(int to);
//! map
/*!
maps the Layer from
*/
	int map(int from);
//! invert
/*!
Inverts the translation.
*/
	void invert();
private:
	int data[layersMax];
};

#endif
