/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PATHPROPERTIES_H
#define PATHPROPERTIES_H
#include "pointarray.h"
#include "ui_pathpropertiesdialog.h"

#include <QDialog>
#include <QTableWidgetItem>

#ifdef WINDOWS64
#define MAXITEMS 15000
#else
#define MAXITEMS 30000
#endif

class path;
class userunitsValidator;
class pathproperties :  public QDialog, private Ui::pathpropertiesdialog
{
  Q_OBJECT

public:
  pathproperties(double units);
  ~pathproperties();
  /*$PUBLIC_FUNCTIONS$*/
 path *element;
 pointArray array;
private:
  QTableWidgetItem item[MAXITEMS];
  void updateElement();
public slots:
  /*$PUBLIC_SLOTS$*/
   void setElement(path *b,bool);
   void setLayerName(int val);
   void setCoordinates();
   void setEdit(QTableWidgetItem *);
   void DoneToPolygon(){updateElement();done(3);}
   void DoneCloseToPolygon(){updateElement();done(4);}
   void DoneDeletePath(){done(2);}
   void updateItem(QTableWidgetItem *b,QTableWidgetItem *c);
   void showAttributes();
   void displayAll();
   void editPoint();
   void setArc();
   void checkInput(const QString&);
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
private:
 double userunits;
 int decimals;
 QPoint center;
 int radiusValue;
 int numCirclePoints;
 double startAngle,endAngle;
 userunitsValidator *valid;
};

#endif

