/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef POLYGONPROPERTIES_H
#define POLYGONPROPERTIES_H

#include "ui_polygonpropertiesdialog.h"
#include "pointarray.h"
#include <QDialog>
#include <QTableWidgetItem>

#ifdef WINDOWS64
#define MAXITEMS 15000
#else
#define MAXITEMS 30000
#endif

class polygon;
class box;
class userunitsValidator;
class polygonproperties : public QDialog, private Ui::polygonpropertiesdialog
{
  Q_OBJECT

public:
  polygonproperties(double units);
  ~polygonproperties();
  /*$PUBLIC_FUNCTIONS$*/
 polygon *element;
 pointArray array;
private:
  QTableWidgetItem item[MAXITEMS];
  void updateElement();
public slots:
  /*$PUBLIC_SLOTS$*/
   void setElement(polygon *b,bool);
   void setLayerName(int val);
   void setCoordinates();
  void setEdit(QTableWidgetItem *);
   void DoneToBox(){updateElement();done(3);}
   void DoneDeletePolygon(){done(2);}
   void updateItem(QTableWidgetItem *b,QTableWidgetItem *c);
   void checkInput(const QString&);
   void checkInputWidth(const QString&);
   void checkInputHeight(const QString&);
   void checkBox();
   void setCircle();
   void setSector();
   void setBox(box *);
   void editPoint();
   void convertToCircle();
   void showAttributes();
  void displayAll();
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
private:
 double userunits;
 int decimals;
 QPoint center;
 int radiusValue;
 int numCirclePoints;
 double startAngle,endAngle;
 userunitsValidator *valid;
 bool calcOperation;
 void setBoxWidthHeight();
};

#endif

