/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "propertylist.h"
#include "fileformats/gds.h"






propertyItem::propertyItem()
{
  nameType=propertyNone;
  valueType=propertyNone;
}

propertyItem::propertyItem(int num){
  nameType=propertyInt;
  propertyNum=num;
  valueType=propertyNone;
}

propertyItem::propertyItem(int num, QString value){
  nameType=propertyInt;
  propertyNum=num;
  valueType=propertyString;
  propertyValueString= new QString(value);
  //printf("create item %d %d %s\n",valueType,propertyValueString,propertyValueString->toAscii().data());
}

propertyItem::propertyItem(int num,int value){
  nameType=propertyInt;
  propertyNum=num;
  valueType=propertyInt;
  propertyValueNum=value;
}

propertyItem::propertyItem(QString name, QString value){
  nameType=propertyString;
  propertyName= new QString(name);
  valueType=propertyString;
  propertyValueString= new QString(value);
}

propertyItem::propertyItem(QString Name){
  nameType=propertyString;
  propertyName= new QString(Name);
  valueType=propertyNone;
}

propertyItem::~propertyItem()
{
//	printf("destroy item %d %d %d %d\n",nameType,valueType,propertyName,propertyValueString);
    if(nameType==propertyString) delete propertyName;
    if(valueType==propertyString) delete propertyValueString;
}

void propertyItem::setValue( QString value){
 if (valueType==propertyString) *propertyValueString=value;
 else propertyValueString=new QString(value);
 valueType=propertyString;
}

void propertyItem::setValue( int value){
	if(valueType==propertyString) delete propertyValueString;
    valueType=propertyInt;
	propertyValueNum=value;
}
void propertyItem::setValue( float value){
	if(valueType==propertyString) delete propertyValueString;
    valueType=propertyFloat;
	propertyValueFloat=value;
}

void propertyItem::setName(QString name){
   if (nameType==propertyString) *propertyName=name;
 else propertyName=new QString(name);
 nameType=propertyString;
}

int propertyItem::getNum()const{
	if (nameType==propertyInt) return propertyNum;
	else if (nameType==propertyString) {
		QString propS=(*propertyName);
        propS.remove(QRegExp("\\D"));//remove all non digits
        //printf("%s\n",propS.toAscii().data());
		return propS.toInt();
	}
	return 0;
}
bool propertyItem::isNum()const{
	if (nameType==propertyInt) return true;
	return false;
}

QString propertyItem::getString()const{
	if (nameType==propertyInt) {
		QString s;
		s.setNum(propertyNum);
		return s;
	}
	else if (nameType==propertyString) return (*propertyName);
	return 0;
}

QString propertyItem::getValueString()const{
if (valueType==propertyString) return (*propertyValueString);
QString s;
if (valueType==propertyInt)  s.setNum(propertyValueNum);
else if (valueType==propertyFloat)  s.setNum(propertyValueFloat);
else
return QString(" ");
//printf("%s\n",s.toAscii().data());
return s;
}

int propertyItem::getValueInt()const{
if (valueType==propertyInt) return propertyValueNum;
return -1;
}


