/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CIF_H
#define CIF_H
#include "general/layers.h"
#include <qobject.h>
//Added by qt3to4:
#include <QTextStream>
#include <QHash>
#include "general/errorreport.h"
#include "filegeneral.h"
/**
@author Juergen Thies
*/
class drawingField;
class cif : public QObject
{
Q_OBJECT
public:
    cif(QObject *parent = 0, const char *name = 0);

    ~cif();
  static void open(QString filename,drawingField *);
  static void import(QString filename,drawingField *);
  static void update(QString filename,drawingField *);
  static void save(QString filename,drawingField *);
  void writeEntry( QString wert);
  QHash<QString,uint> hashList;
  QHash<uint,cell*> cellsList;
  int cellNum;
  errorreport report;
  errorreport *reportSave;
  int a,b;
private:
  void save(QTextStream *streamPtr,drawingField *, errorreport *error);
  QTextStream *stream;
  QString puffer;
  bool layerused[layersMax];
  void load(QString filename,drawingField *,  fileOpenType type);
  QString readString ();
  int getInt(QString s, int *pos);
  QPoint getPoint(QString s, int *pos);
  QString getString(QString s, int *pos);

};

#endif
