/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOURCE_H
#define SOUCRE_H

#include <qobject.h>
#include <qstring.h>
#include "filegeneral.h"
#include "filewrite.h"
#include "elements/strans.h"
#include <QHash>
/**
@author Juergen Thies
*/
class errorreport;
class drawingField;
class fileRead;

class source : public QObject
{
Q_OBJECT
public:
    source(QObject *parent = 0, const char *name = 0);

    ~source();

errorreport *error;
fileWrite *write;


//void save(QDataStream *streamPtr,drawingField *, errorreport *report);       

static void open(QString filename,drawingField *);
static void import(QString filename,drawingField *);
static void update(QString filename,drawingField *);
static void save(QString filename,drawingField *);


void writePos(int);
void writeLayer(int);
void writeOrientation(strans t);
void writeString(QString s,bool cell=true);
void blockTest(int words);
void count(int words);
static QString cellname(QString name);
private:
long long recordCount;
drawingField *drawing;
QStringList needCells;
void save(cell *c);

static void load(QString filename,drawingField *, fileOpenType type);
void open(QString filename,QString cellname);
static QString readString (fileRead *stream,int items);

static QPoint readPoint(fileRead *f,QList<int> *l=NULL);
static int readLayer(fileRead *f);
static int readWord(fileRead *f);
static int readPos(fileRead *f,QList<int> *l=NULL);

};

#endif
