/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drawpixmap.h"
#include "setup.h"
//Added by qt3to4:
#include <QPixmap>
#include "elements/element.h"


drawpixmap::drawpixmap(int x,int y,int left,int top,double scale_):layoutPixmap(x,y)

{

  scaleMutex.lock();
  trans.setMirror_x();
  trans.translate(left,top);
  trans.scale(scale_);
  scaleMutex.unlock();
  imageChanged=true;
}

drawpixmap::drawpixmap(int x,int y,drawpixmap *d):layoutPixmap(x,y)
{

  scaleMutex.lock();
  trans=d->trans;
  scaleMutex.unlock();

}

drawpixmap::~drawpixmap(){

}


void drawpixmap::setTrans(strans t){
//printf("set trans\n");
  bool b=true;
  double xa,ya;
  double xb;
  xb=2.0*(1<<30)-1-(1<<28);
  t.matrix.map(-xb,xb,&xa,&ya);
  if (xa>0) b=false;
  if (ya>0) b=false;
  t.matrix.map(xb,-xb,&xa,&ya);
  if (xa<width()) b=false;
  if (ya<height()) b=false;
  if (b) {
  	trans=t;
	}
}

void drawpixmap::move(int left,int top){
  //matrix.translate((int)((double)(left)/scale),-(int)((double)(top)/scale));
  bool releaseMutex=false;
  if (scaleMutex.tryLock()) {releaseMutex=true;}
  strans t=trans;
  t.translate((int)((double)(left)/trans.mag),-(int)((double)(top)/trans.mag));
  setTrans(t);
  if (releaseMutex) scaleMutex.unlock();
}

void drawpixmap::changeScale(double scale_,int x_,int y_){
  bool releaseMutex=false;
  //printf("start change scale %f\n",trans.mag);
  if (scaleMutex.tryLock()) {releaseMutex=true;}
  QMatrix matrixinv=trans.matrix.inverted();
  double x,y;
  x=(double)x_;
  y=(double)y_;
  x=x*matrixinv.m11()+y*matrixinv.m21()+matrixinv.dx();
  y=+y*matrixinv.m22()+x*matrixinv.m12()+matrixinv.dy();
  x=-x*scale_+x_;
  y=+y*scale_+y_;
  strans t;
  t.matrix.setMatrix(scale_,0,0,-scale_,(int)x,(int)y);
  t.mag=scale_;
  t.angle=0;
  t.mirror_x=true;
  setTrans(t);
  if (releaseMutex) scaleMutex.unlock();
  //printf("end change scale %f\n",trans.mag);
}

void drawpixmap::setScale(double scale_,int x_,int y_){
  bool releaseMutex=false;
  if (scaleMutex.tryLock()) {releaseMutex=true;}
  strans t=trans;
  t.matrix.setMatrix(scale_,0,0,-scale_,(int)x_*scale_,(int)y_*scale_);
  t.mag=scale_;
  t.angle=0;
  t.mirror_x=true;
  setTrans(t);
  if (releaseMutex) scaleMutex.unlock();
}

void drawpixmap::getScale(double *scale_,int *x_,int *y_){
  bool releaseMutex=false;
  if (scaleMutex.tryLock()) {releaseMutex=true;}
  (*scale_)=trans.mag;
  (*x_)=int(trans.matrix.dx()/(*scale_));
  (*y_)=int(trans.matrix.dy()/(*scale_));
  if (releaseMutex) scaleMutex.unlock();
}

void drawpixmap::drawPrepare(){
  scaleMutex.lock();
  strans s=trans;
  s.translate(element::runden(1.0/s.mag),-element::runden(1.0/s.mag));
  setDrawTrans(s);
//  drawPixelSize=(int)(1.0/drawTrans.mag);
//  elementDraw=false;
  scaleMutex.unlock();
  layers::calLayerColor();
}


int drawpixmap::width(){
 return image->width()-2;
}

int drawpixmap::height(){
 return image->height()-2;
}
