/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "defines.h"
#include "layout.h"
#include "general/drawingfield.h"
#include "widgets/layerbutton.h"
#include "widgets/layersetupbutton.h"
#include "widgets/newcombobox.h"
#include "widgets/cellcombo.h"
#include "widgets/lineedit.h"
#include "general/reportview.h"
#include "general/setup.h"
#include "general/project.h"
#include "fileformats/filedialog.h"
#ifdef BOOL_LAYOUT
#include "boolle/booleanhandler.h"
#else
#include "boolgpl/booleanhandler.h"
#endif
#include "macro/macro.h"
#include "macro/macromenuentry.h"
#include "general/paintpixmapthread.h"
#include "widgets/multitoolbutton.h"
#include "widgets/singletoolbutton.h"
#include "widgets/mousehelp.h"
#include "widgets/mousewidget.h"
#include "widgets/layertool.h"
#include "widgets/singletoolbutton.h"
#include "widgets/layerbutton.h"
#include "widgets/layertool.h"
#include "widgets/selectwidget.h"
#include "widgets/gridwidget.h"
#include "widgets/timewidget.h"
#include "widgets/poswidget.h"
#include "dialog/setupwindow.h"
#include "dialog/selectgrid.h"
#include "dialog/selectcell.h"
#include "dialog/moveby.h"
#include "dialog/gotoxy.h"
#include "dialog/drcangle.h"
#include "dialog/drcarea.h"
#include "dialog/drcdimension.h"
#include "dialog/drcminsize.h"
#include "dialog/drcmindistance.h"
#include "dialog/drcmindistanceoverlap.h"
#include "dialog/drcnoholes.h"
#include "dialog/drcinside.h"
#include "dialog/drclayercombination.h"
#include "dialog/modifycorners.h"
#include "dialog/sizeadjust.h"
#include "dialog/cellselect.h"
#include "dialog/setuserunit.h"
#include "dialog/selectcell.h"
#include "dialog/boolonlayer.h"
#include "elements/cell.h"
#include "elements/celllist.h"
#include "macro/menus.h"
#include <QWhatsThis>
#include <QFileDialog>
#include <QImageWriter>
#include <qimage.h>
#include <QBitmap>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qmenubar.h>
//#include <qfile.h>
#include <QStatusBar>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <qcolordialog.h>
#include <qinputdialog.h>
#include <qvalidator.h>
#include <qdir.h>
#include <QImageIOPlugin>
#include <QCloseEvent>
#include <QResizeEvent>
#include <QToolBar>
#include <QPrintDialog>
#include <QPixmap>
#include "general/setup.h"
#include <QKeySequence>
#include "drc/drc.h"
#include "general/guiworkthread.h"
#include <QMutex>
#include <QBuffer>
#include <QClipboard>
#include <QDesktopServices>
#include "general/lastopen.h"
#include "widgets/tool3dbutton.h"
#ifdef USE_3d
#include "3d/view3dmodule.h"
#include "3d/window3d.h"
#include "3d/widget3d.h"
#endif
#ifdef barcodeutility
#include "barcode/barcodemodule.h"
#endif
#ifdef backgroundutility
#include "background/backgroundmodule.h"
#endif
#ifdef extractionutility
#include "extraction/extractionmodule.h"
#endif
#ifdef SCHEMATIC
#include "schematic/schematic.h"
#include "schematic/schematicdisplay.h"
#endif
#ifdef TEXTEDIT
#include "textedit/textedit.h"
#endif
#ifdef OPENACCESS
#include "oa/oamodule.h"
#include "oa/tclinterpreter.h"
#endif
/**
@author Juergen Thies
*/

//bool getDebugFlag();

bool layout::debug=false;
bool layout::basicMode=false;

layout::layout(viewModeType view)
    : mainWindow()
{   
    viewMode=view;
#ifdef PYTHON
    viewMode=puremode;
#endif
    posStatus=NULL;
    timeStatus=NULL;
    gridStatus=NULL;
    selectStatus=NULL;
    commandLineTools=NULL;
    cellcombo=NULL;
    mouseHelps=NULL;
    layerTools=NULL;
    guiLocked=false;
    snapToPointButton=0;
    snapToGridButton=0;
    snapToMiddleButton=0;
    snapToLineButton=0;
    snapToCenterButton=0;
    snapToIntersection=0;
    drawing=NULL;
#ifdef LIBCHECK
#include "../liblayout/libcheck.cpp"
if (libCheckResult) return;
#endif
    //printer->setResolution(200);
    drawing=new drawingField(this,"Zeichnung");

    workThread=new guiWorkThread(this);
    drawing->setFocus();
    setCentralWidget( drawing );
    gridcombo=NULL;
    setup=new setupWindow(this);
    booleanTool=new booleanHandler(drawing,this);
    drcTool=new drc(drawing,this);
    #ifdef barcodeutility
    barcodeTool=new barcodeModule(drawing,this);
    #endif
    #ifdef backgroundutility
    backgroundTool=new backgroundModule(drawing,this);
    #endif
    #ifdef extractionutility
    extractionTool=new extractionModule(drawing,this);
    #endif
    #ifdef OPENACCESS
    oaTool=new oaModule2(drawing,this);
    #endif
    setup->setHelpWindow(helpwindow);
    //if (viewMode!=puremode) {
      addLayerDock();
    //}

    connect(drawing,SIGNAL(mousePosChange(QPoint)),this,SLOT(zeigeMousePos(QPoint)));
    connect(drawing,SIGNAL(mousePosDifChange(QPoint,QPoint)),this,SLOT(zeigeDifPos(QPoint,QPoint)));
    connect(drawing,SIGNAL(message(QString)),this,SLOT(zeigeString(QString)),Qt::QueuedConnection);
    connect(drawing,SIGNAL(rightclick()),this,SLOT(showMainmenu()));
    connect(drawing,SIGNAL(rightclick(QMenu *)),this,SLOT(showMainmenu(QMenu *)));
    connect(drawing,SIGNAL(gridChange()),this,SLOT(updateGrid()));
    connect(drawing,SIGNAL(moveByRequest()),this,SLOT(moveBy()));
    connect(drawing,SIGNAL(copyByRequest()),this,SLOT(copyBy()));
    connect(drawing,SIGNAL(activeLayerChanged()),this,SLOT(updateSetupLayerbutton()),Qt::QueuedConnection);
    connect(drawing,SIGNAL(newMode(int)),this,SLOT(setNewMode(int)),Qt::QueuedConnection);
    connect(drawing,SIGNAL(cellsChange()),this,SLOT(cellsUpdate()),Qt::QueuedConnection);
    connect(drawing,SIGNAL(currentCellChanged()),this,SLOT(currentCellUpdate()),Qt::QueuedConnection);
 
	if (viewMode==defaultmode) {
		//load mode from setup
		switch (setup::getViewMode()){
			case 1:
#ifndef FULL_VERSION
				viewMode=basicmode;
				break;
#endif
			case 2:
				viewMode=intermediatemode;
#ifndef FULL_VERSION
				viewMode=basicmode;
#endif
				break;
			case 3:
				viewMode=basicmode;
				break;
			case 4:
				viewMode=viewermode;
				break;
#ifdef ADDON_CUSTOMMODE
			case 5:
				viewMode=custommode;
				break;
#endif
			default:
#ifndef FULL_VERSION
				viewMode=basicmode;
				break;
#endif
		}
		}
#ifndef GENISYS
#endif
#ifdef USE_3d
    view3dTool=NULL;
if ((viewMode==fullmode)||(viewMode==custommode)||(viewMode==puremode))
    add3dDock();

#endif
//    viewonly=false;
	switch (viewMode){
	case viewermode:
		{
            QList<int> list;
			list.clear();
			list<<1019<<1024<<1025<<1083<<1149;
			addToolbar(tr("File Operations"),list);
			list.clear();
			list<<1035<<1036<<1037<<1038<<0<<1039<<1040<<1041<<1043<<1223;
			addToolbar(tr("Navigation Tools"),list);
			list.clear();
			list<<11001;
			addToolbar(tr("Cell Tools"),list);
			list.clear();
    		list.clear();
			list<<-1<<1019<<0<<1149<<0<<1083<<12000;
			addMenu(tr("File"),list);
			list.clear();
			list<<-2<<1037<<1038<<1035<<1036<<0<<1043<<1039<<1040<<1041<<1223;
			addMenu(tr("Zoom"),list);
			list.clear();
			list<<0<<1146<<
			1147<<12003<<0<<1148;
			addMenu(tr("Help"),list);
			drawing->setDefaultMode(200);
		}
		break;
    case basicmode:
		{  
			QList<int> list;
			list<<1001<<1000<<1002<<1003<<1005; //<<0<<1006<<1007<<1013<<1016;
			addToolbar(tr("Drawing Tools"),list);
			list.clear();
			list<<1231;
			addToolbar(tr("Select Tools"),list);
			list.clear();
			list<<1235<<1043;//1039<<1040<<1041<<1043<<1223;
			addToolbar(tr("Navigation Tools"),list);
			list.clear();
			list<<11000<<1057<<1068;
			addToolbar(tr("Grid Tools"),list,false);
			//addToolBarBreak( Qt::TopToolBarArea);
			list.clear();
			list<<1019<<1236<<0<<1083;
			addToolbar(tr("File Operations"),list);
			list.clear();
			list<<11001<<0<<1052<<1053;
			addToolbar(tr("Cell Tools"),list);
			list.clear();
			list<<-1<<1001<<1000<<1002<<1003<<1005<<0<<1006<<1007<<1016;
			addMenu(tr("Draw"),list);
			list.clear();
			list<<-1<<1026<<1027<<1028<<0<<1029<<1030<<1031<<0<<1231;
			addMenu(tr("Select"),list);
			list.clear();
			list<<-2<<1044<<1046<<1047<<1048<<0<<1052<<1053;
			addMenu(tr("Cell"),list);
			list.clear();
			list<<-2<<1019<<1022<<1023<<0<<1024<<1025<<0<<1149<<0<<1083<<12000;
			addMenu(tr("File"),list);
			list.clear();
			list<<-3<<1037<<1038<<1035<<1036<<0<<1043<<1039<<1040<<1041<<1223<<0<<1054<<1057<<1068;
			addMenu(tr("Zoom"),list);
			list.clear();
			list<<0<<1146<<
			1147<<12003<<0<<1148;
			addMenu(tr("Help"),list);
		}
	    break;
	case intermediatemode:
		{
		}
	    break;
	case fullmode:
	    break;
#ifdef ADDON_CUSTOMMODE
	case custommode:
#include "addon/custommode.cpp"
	    break;
#endif
#ifdef GENISYS
	case genisysmode:
	case genisysmodenoopen:
#include "addon/custommode-genisys.cpp"
	    break;
#endif
	case puremode: {
			QList<int> list;

		}
	      break;
	default:
		break;
	}

    if (viewMode==viewermode) drawing->setZoomMode();
    if (viewMode!=puremode) addMouseHelp();

    setup::loadSettings(this);

    if (viewMode==fullmode) addMacros();
/*    if ((viewMode==genisysmode)||(
	viewMode==genisysmodenoopen)) addMacros();
	*/
    posStatus=new poswidget(this,NULL,"position");
    statusBar()->addWidget(posStatus,0);
    timeStatus=new timewidget(this,"time");
    statusBar()-> addPermanentWidget(timeStatus,0);
    connect(drawing,SIGNAL(drawingTime(int)),timeStatus,SLOT(setDrawTime(int)),Qt::QueuedConnection);
    connect(drawing,SIGNAL(detailedLevelChanged(quint8)),timeStatus,SLOT(setDrawDetail(quint8)),Qt::QueuedConnection);
    gridStatus=new gridwidget(this,NULL,"grid");
    statusBar()-> addPermanentWidget(gridStatus,0);
    if (viewMode!=viewermode) {  
    	selectStatus=new selectwidget(this,NULL,"select");
    	statusBar()-> addPermanentWidget(selectStatus,0);
    	connect(drawing,SIGNAL(selectChange(elementCount)),selectStatus,SLOT(setSelect(elementCount)));
	connect(drawing,SIGNAL(selectReset()),selectStatus,SLOT(reset()));
    	}
    else {selectStatus=NULL;}
    gridAuto();
    setStatusBarSize(width());
    
    drawing->setFocus();
    userGridChange=true;

// workThread----------
    
    connect(workThread,SIGNAL(operationTime(int)),timeStatus,SLOT(setTime(int)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(operationIcon(QString)),timeStatus,SLOT(setIcon(QString)),Qt::QueuedConnection);

    connect(workThread,SIGNAL(showReport(QString,int)),this,SLOT(showReport(QString,int)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(showMessage(QString)),this,SLOT(zeigeString(QString)),Qt::QueuedConnection);
    connect(drawing,SIGNAL(report(QString,int)),this,SLOT(showReport(QString,int)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askSaveModifications()),this,SLOT(askSaveModifications()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askOpenFilename()),this,SLOT(askOpenFilename()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askSaveFilename()),this,SLOT(askSaveFilename()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askTextEditor()),this,SLOT(askTextEditor()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askSchematic()),this,SLOT(askSchematic()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(setWindowTitle(QString)),this,SLOT(setTitle(QString)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(recountSelect()),drawing,SLOT(recountSelect()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(cellsUpdate()),this,SLOT(cellsUpdate()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(updateGrid()),this,SLOT(updateGrid()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(updateSetupLayerbutton()),this,SLOT(updateSetupLayerbutton()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(showMessage(QString,QString)),this,SLOT(showMessage(QString,QString)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askText(QString,QString,QString)),this,SLOT(askText(QString,QString,QString)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askDouble(QString,QString, double,int)),this,SLOT(askDouble(QString,QString,double,int)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askInteger(QString,QString, int)),this,SLOT(askInteger(QString,QString,int)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askBool(QString,QString)),this,SLOT(askBool(QString,QString)),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askCell()),this,SLOT(askCell()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askPrint()),this,SLOT(askPrint()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askScreenshot()),this,SLOT(askScreenshot()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askCellName()),this,SLOT(askCellName()),Qt::QueuedConnection);
    connect(workThread,SIGNAL(askShowMessage(QString,QString)),this,SLOT(askShowMessage(QString,QString)),Qt::QueuedConnection);

//---------------------
    connect(drawing,SIGNAL(undoEnable(bool)),this,SLOT(undoEnable(bool)));
    connect(drawing,SIGNAL(redoEnable(bool)),this,SLOT(redoEnable(bool)));
    connect(drawing,SIGNAL(requestFontSetup()),setup,SLOT(openFont()));
//printf("layout const\n");


}

void layout::addMouseHelp(){
  mouseHelps =new mouseHelp(this,"Mousehelp");
  addDockWidget(Qt::LeftDockWidgetArea,mouseHelps);
  connect(mouseWidget::mouseInfo,SIGNAL(changed()),mouseHelps->mouseWidgets,SLOT(update()));
}


void layout::spezialToolbar(int num){
if (num==11000){
	gridcombo= new newComboBox(toolBar[toolBarNext]);
	gridcombo->clear();
	gridcombo->setEditable(true);
	gridcombo->setInsertPolicy(QComboBox::InsertAtTop);
	gridcombo->setMaxCount(10);
	gridcombo->setFixedWidth(100);
	QDoubleValidator *valid=new QDoubleValidator((double)0.000001,(double)1000000,6,gridcombo);
	gridcombo->setValidator(valid);
	gridcombo->help=setGridHelp;
	toolBar[toolBarNext]->addWidget(gridcombo);
	connect(gridcombo,SIGNAL(activated(const QString &)),this,SLOT(gridChange(const QString & )));
	connect(gridcombo,SIGNAL(editTextChanged(const QString &)),this,SLOT(gridChange(const QString & )));
}
else if (num==11001){
	cellcombo= new cellCombo(toolBar[toolBarNext],this);
	//cellcombo= new newComboBox(toolBar[toolBarNext]);
	cellcombo->setToolTip(tr("Cell Select"));
	cellcombo->clear();
	cellcombo->setFixedWidth(290);
	cellcombo->setMaxVisibleItems(30);
	cellcombo->help=selectCellHelp;
	QAction *a=toolBar[toolBarNext]->addWidget(cellcombo);
	a->setWhatsThis("No Documentation!");
	connect(cellcombo,SIGNAL(activated(const QString &)),drawing,SLOT(setCellGui(const QString & )));
	connect(cellcombo,SIGNAL(activated(const QString &)),this,SLOT(emitNewCurrentCell(const QString &)));
	cellsUpdate();
}
else if (num==11002){
        macroMultiButton=multiToolButtonNext;
}
else if (num==12004){
       #if USE_3d
         view3dTool->addAnglesButton(toolBar[toolBarNext]);
       #endif
}
else if (num<=1082){
	QString textLabel;
	QObject *receiver;
	const char * slot;
	helpText helptext;
	getFunctionInfo(num,&textLabel,&receiver,&slot,&helptext);
	switch (num){
      		case 1077:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapGrid), toolBar[toolBarNext],  helptext );
                        snapToGridButton=singleToolButtonNext;
			break;
		case 1078:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapPoint), toolBar[toolBarNext],  helptext );
			snapToPointButton=singleToolButtonNext;
			break;
		case 1079:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapLine), toolBar[toolBarNext],  helptext );
			snapToLineButton=singleToolButtonNext;
			break;
		case 1080:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapMiddle), toolBar[toolBarNext],  helptext );
			snapToMiddleButton=singleToolButtonNext;
			break;
		case 1081:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapCenter), toolBar[toolBarNext],  helptext );
			snapToCenterButton=singleToolButtonNext;
			break;
		case 1082:
			singleButton[singleToolButtonNext] = new singleToolButton(
				textLabel,&(drawing->snapIntersection), toolBar[toolBarNext],  helptext );
			snapToIntersection=singleToolButtonNext;
			break;
	}
}
else if (num==11002){
      
}
else if (num==11002){
      
}
else if (num==11002){
      
}
}


void layout::getFunctionInfo(int function, QString *textLabel, QObject ** receiver, const char ** slot,helpText *helptext){
	switch (function){
#include "autogen/getfunctioninfo.cpp"
	default:
		    *textLabel=tr("no function");
			*receiver=NULL;
			*slot=SLOT(setCellnameGui());
			*helptext=setCellnameHelp;
		    break;
	}
}




void layout::addLayerDock(){
    layerTools =new layerTool(this,"Layertools");
    addDockWidget(Qt::LeftDockWidgetArea,layerTools);
    connect(layerTools,SIGNAL(shortkeyFinished()),drawing,SLOT(setFocus()));
    int i;
    QString s=QString("Layer");
    layoutMenu[menuNext]=menus::addMenu(mainMenu,&s,&menuList,this);
    QMenu * layermenu = layoutMenu[menuNext];
    menuNext++;
    layermenu->setTitle(QString("&")+tr("Layer"));
    QAction *a= menuBar()->addMenu(layermenu );
    a=mainmenu->addMenu(layermenu);
    QString menuName="Main/Layer";

    QMenu *menu=layermenu;
    
    QMenu *neuMenu=NULL;
    for (i=0;i<layers::displayedLayers;i++){
       if ((i%32)==0){
		neuMenu = menus::addMenu(menus::findMenu(&menuName,menuList),&s,&menuList,this);
		menu->addMenu(neuMenu);
		QString s1,s2;
		s1.setNum(i);
		int end=i+31;
		if (end>=layers::displayedLayers) end=layers::displayedLayers-1;
		s2.setNum(end);
		//menuName="Main/Layer/Layer "+s1+"-"+s2;
    		neuMenu->setTitle(tr("Layer")+" "+s1+" - "+s2);
       }
       layerTools->button[i]->setWhatsThis("no documentation");
       QAction *a; 
       a = neuMenu->addMenu(&layerTools->button[i]->popup);
    }
 /*   for (i=0;i<layers::displayedLayers;i++){ 
       if (((i)%32==0)&&(i!=0)) {
		s=tr("more Layers...");
		QMenu *neuMenu = menus::addMenu(menus::findMenu(&menuName,menuList),&s,&menuList,this);
		menu->addMenu(neuMenu);
		menu=neuMenu;
		menuName+="/more Layers...";
    		menu->setTitle(tr("more Layers..."));
		}
       layerTools->button[i]->setWhatsThis(helpwindow->getWhatsthis(layerButtonHelp));
       QAction *a; 
       a = menu->addMenu(&layerTools->button[i]->popup);
       }*/
}
    
    
void layout::add3dDock(){
#ifdef USE_3d
#endif
}

void layout::addCommandLineDock(){
    QString text = tr("<p>Command Line: all Methods of the Class DrawingField can be entered and are executed directly.</p>");
    commandLineTools = new QToolBar(  "commandline",this );
    commandLineTools->setWindowTitle( tr("Command Line Tools") );
    commandLineTools->setObjectName (tr("Command Line Tools"));
    addToolBar(Qt::BottomToolBarArea,commandLineTools);
    commandLineTools->hide();
    commandLine=new lineEdit();
    commandLineTools->addWidget(commandLine);
    commandLine->clear();
    commandLine->help=commandHelp;
    connect(commandLine,SIGNAL( returnPressed ()),this,SLOT(commandLineEnter()));
	connect(drawing,SIGNAL(tabPressed()),this,SLOT(commandlineActivate()));
	commandlineTab=false;
}

void layout::commandlineActivate(){
	if (commandLineTools!=NULL){
		if (!commandLineTools->isVisible()){
					commandLineTools->show();
					commandlineTab=true;
					}
		commandLineTools->setFocus();
	}
}

void layout::commandLineEnter(){
setup::ngpl();
 if (commandLine->text().trimmed()!=""){
	 if (commandlineTab) {
		 commandLineTools->hide();
		 commandlineTab=false;
	 }
    macro m(this);
    errorreport error;
    QString s=commandLine->text().trimmed();
    if (s.contains(";")) s=commandLine->text().trimmed()+"";
    else if (s.contains("(")||s.contains(")")||s.contains("=")){
    	s="layout->drawing->"+commandLine->text().trimmed()+";";}
    else if (s.contains(" ")) {
	int f=s.indexOf(" ");
	s.replace(f,1,"(");
	s.replace(" ",",");
	s="layout->drawing->"+s+");";
	}
    else s="layout->drawing->"+commandLine->text().trimmed()+"();";
    if (drawing->mutexChangeGuiTryLock()) {
	drawing->autorepaint=false;
	drawing->prepareUndo();
    	bool macrorecord=drawing->record;
    	drawing->record=false;
	//printf("%s\n",s.toAscii().data());
    	m.executeSingle(s,&error );
    	drawing->mutexChangeUnlock();
    	if (macrorecord) {
		drawing->record=true;
		drawing->macroAdd(s);
		}
	   commandLine->clear();
	   emit updateGui();
	   drawing->autorepaint=true;
	   drawing->paint();
#ifdef USE_3d
	   if (view3dTool!=NULL) view3dTool->trigger3dProcess();
#endif
 	   updateSetupLayerbutton();
 	   drawing->recountSelect();
 	   cellsUpdate();
 	   updateGrid();
 	   setTitle( filename );
 	   error.showReport();
 	   statusBar()->showMessage( errorreport::getLastRangString(), 2000 );}}
}
/*

*/
layout::~layout()
{   
    emit closed();
 if (layout::debug) printf("layout destruct\n");
//QTime t;
//t.start();
//printf("end layout 1\n");
    undoButton=NULL;
    undoAction=NULL;
    redoButton=NULL;
    redoAction=NULL;
 if (layout::debug) printf("layout destruct posStatus\n");
    if (posStatus!=NULL) delete posStatus;
 if (layout::debug) printf("layout destruct gridStatus\n");
    posStatus=NULL;
    if (gridStatus!=NULL) delete gridStatus;
 if (layout::debug) printf("layout destruct timeStatus\n");
    gridStatus=NULL;
    if (timeStatus!=NULL) delete timeStatus;
 if (layout::debug) printf("layout destruct setup\n");
    timeStatus=NULL;
    if (setup!=NULL) delete setup;
 if (layout::debug) printf("layout destruct selectStatus\n");
    setup=NULL;
    if (selectStatus!=NULL) delete selectStatus;
 if (layout::debug) printf("layout destruct lstFiles\n");
    selectStatus=NULL;
    if (lastFiles!=NULL) delete lastFiles;
 if (layout::debug) printf("layout destruct commandLineTools\n");
    lastFiles=NULL;
    if (commandLineTools!=NULL) delete commandLineTools;
 if (layout::debug) printf("layout destruct layerTools\n");
    commandLineTools=NULL;
    if (layerTools!=NULL) delete layerTools;
    layerTools=NULL;
  if (layout::debug) printf("layout destruct mouseHelp\n");
    if (mouseHelps!=NULL) delete mouseHelps;
    mouseHelps=NULL;
  if (layout::debug) printf("layout destruct macroList\n");
    delete macroList;

#ifdef USE_3d
    //if (dockwindow3d!=NULL)  delete dockwindow3d;
 if (layout::debug) printf("layout destruct view3dTool\n");
    if (view3dTool!=NULL) delete view3dTool;
    view3dTool=NULL;
//    if (tools3d!=NULL) delete tools3d;
//    QMenu *menu3d;
//    tool3dButton *angles3d[3];
#endif
//printf("end layout 9\n");
#ifdef barcodeutility
 if (layout::debug) printf("layout destruct barcodeTool\n");
    delete barcodeTool;
#endif
#ifdef backgroundutility
 if (layout::debug) printf("layout destruct backgroundTool\n");
    delete backgroundTool;
#endif
#ifdef extractionutility
    if (layout::debug) printf("layout destruct extractionTool\n");
    delete extractionTool;
#endif
#ifdef OPENACCESS
  if (layout::debug) printf("layout destruct oaTool\n");
    delete oaTool;
#endif
  if (layout::debug) printf("layout destruct booleanTool\n");
    delete booleanTool;
   if (layout::debug) printf("layout destruct drcTool\n");
    delete drcTool;
/*  
   nicht gelschte objecte

    QToolBar *toolBar[30];
	QMenu *layoutMenu[30];

    menus *menuList, *mainMenu;

*/
 if (layout::debug) printf("layout destruct workThread\n");
    delete workThread;
  if (layout::debug) printf("layout destruct drawing\n");
    delete drawing;
 if (layout::debug) printf("layout destruct buttons\n");
    for (int i=0;i<multiToolButtonNext;i++) {
	delete multiButton[i];
	}
    for (int i=0;i<singleToolButtonNext;i++) {
	delete singleButton[i];
	}
    for (int i=0;i<actionNext;i++) {
	delete action[i];
	}

 if (layout::debug) printf("layout destruct end\n");

//printf("time: %d ms\n", t.elapsed());

}

void layout::setGrid(){
  setup::ngpl();
    //drawing->setCursor(QCursor(Qt::ForbiddenCursor));
    selectGrid b;
    b.gridX->setValue(drawing->gridX*drawing->userunits);
    b.gridY->setValue(drawing->gridY*drawing->userunits);
    b.offsetX->setValue(drawing->gridOffsetX*drawing->userunits);
    b.offsetY->setValue(drawing->gridOffsetY*drawing->userunits);
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
	//drawing->setCursor(QCursor(Qt::BlankCursor));
    	return ;
    case QDialog::Accepted :
    	drawing->gridX=element::runden(b.gridX->value()/drawing->userunits);
    	drawing->gridY=element::runden(b.gridY->value()/drawing->userunits);
	drawing->gridOffsetX=element::runden(b.offsetX->value()/drawing->userunits);
	drawing->gridOffsetY=element::runden(b.offsetY->value()/drawing->userunits);
    	drawing->gridauto=false;
    	QString s;
        updateGrid();
   	if (setup::showGrid) drawing->paint();
	//drawing->setCursor(QCursor(Qt::BlankCursor));
	return ;
    }
    //drawing->setCursor(QCursor(Qt::BlankCursor));
    return;
/*
  bool b;
  double d=QInputDialog::getDouble(this,tr("Change Grid"),tr("Enter Grid"),gridcombo->currentText().toDouble(&b),(double)0.000001,(double)1000000,6,&b)/drawing->userunits;
  if (b) {
  	drawing->gridauto=false;
  	int i=(int)(d+0.5);
    	QString s;
   	s=s.setNum(i*drawing->userunits,'g',15);
   	gridcombo->setEditText(s);
   	drawing->setGrid(i);
   	if (setup::showGrid) drawing->paint();
  }*/
}

void layout::gridChange(const QString &grids){
 if (userGridChange) { 
   drawing->gridauto=false;
   bool b;
   double d=grids.toDouble(&b)/drawing->userunits;
   int i=(int)(d+0.5);
   if (i<=0){ i=1;}
   drawing->setGrid(i);
   updateGrid();
   if (setup::showGrid) drawing->paint();}
}

void layout::gridMinus(){
   drawing->gridauto=false;
   int exp=1;
   int grid=drawing->getGrid()*10;
   double d;
   while (grid>=100){grid/=10;exp++;}
   d=grid/10;
   if (d<2){grid=2;}
   else if (d<5) {grid=5;}
   else grid=10;
   while (exp>1) {grid*=10;exp--;}
   drawing->setGrid(grid);
   d=grid*drawing->userunits;
   updateGrid();
   if (setup::showGrid) drawing->paint();
}

void layout::gridPlus(){
   drawing->gridauto=false;
   int exp=1;
   int grid=drawing->getGrid()*10;
   double d;
   while (grid>=150){grid/=10;exp++;}
   d=grid/10;
   if (d<=2){grid=1;}
   else if (d<=5) {grid=2;}
   else grid=5;
   while (exp>1) {grid*=10;exp--;}
   drawing->setGrid(grid);
   d=grid*drawing->userunits;
   updateGrid();
   if (setup::showGrid) drawing->paint();
  
}

void layout::gridAuto(){
  drawing->gridauto=true;
  drawing->setAutoGrid();
  if (gridStatus!=NULL) {
	gridStatus->setAutoMode(true);
  	}
  drawing->paint();
}

void layout::gridAutoPlusMinus(){
	if (QApplication::keyboardModifiers ()==Qt::ShiftModifier) gridPlus();
	else if (QApplication::keyboardModifiers ()==Qt::ControlModifier) gridMinus();
	else gridAuto();
}


void layout::updateGrid(){
  userGridChange=false;
  QString s;
   if (drawing->gridX==drawing->gridY){
   	s=s.setNum(drawing->getGrid()*drawing->userunits,'g',15);
		}
	else {s=tr("asym");}
  if (gridcombo!=NULL) gridcombo->setEditText(s);
  if (gridStatus!=NULL) {
  	gridStatus->setGrid(s);
	gridStatus->setAutoMode(drawing->gridauto);
  	}
  userGridChange=true;
}

void layout::zeigeString(QString s){
  statusBar()->showMessage( s, 3000 );
}

void layout::zeigeMousePos(QPoint pos){
   QString sx,sy;
   sx=sx.setNum((double)pos.x()*drawing->userunits,'g',15);
   sy=sy.setNum((double)pos.y()*drawing->userunits,'g',15);
   //statusBar()->message( sx+","+sy, 5000 );
   if (posStatus!=NULL) posStatus->setPos(sx+","+sy+" ["+getUserunits()+"]");
}

void layout::zeigeDifPos(QPoint pos,QPoint dif){
   QString sx,sy,dx,dy;
   sx=sx.setNum((double)pos.x()*drawing->userunits,'g',15);
   sy=sy.setNum((double)pos.y()*drawing->userunits,'g',15);
   dx=dx.setNum((double)dif.x()*drawing->userunits,'g',15);
   dy=dy.setNum((double)dif.y()*drawing->userunits,'g',15);
   //statusBar()->message( sx+","+sy+" ("+dx+","+dy+")", 5000 );
   if (posStatus!=NULL) posStatus->setPos(sx+","+sy+" ("+dx+","+dy+")"+" ["+getUserunits()+"]");
}

QString layout::getUserunits(){
double d=drawing->databaseunits/drawing->userunits;
//printf("%9.9f\n",d);
if ((d>=0.9999999)&&(d<=1.0000001)) return "m";
if ((d>=0.09999999)&&(d<=0.10000001)) return "dm";
if ((d>=0.009999999)&&(d<=0.010000001)) return "cm";
if ((d>=0.0009999999)&&(d<=0.0010000001)) return "mm";
if ((d>=0.025399999)&&(d<=0.0254000001)) return "inch";
if ((d>=0.0000009999999)&&(d<=0.0000010000001)) return "m";
if ((d>=0.0000253999999)&&(d<=0.0000254000001)) return "mils";
if ((d>=0.000000000999999)&&(d<=0.000000001000001)) return "nm";
if ((d>=0.0000000253999999)&&(d<=0.0000000254000001)) return "inch";
if ((d>=0.0000000000999999)&&(d<=0.0000000001000001)) return "A";
/*if (d==1.0) return "m";
if (d==0.1) return "dm";
if (d==0.01) return "cm";
if (d==0.001) return "mm";
if (d==0.0254) return "inch";
if (d==0.000001) return "m";
if (d==0.0000254) return "mils";
if (d==0.000000001) return "nm";
if (d==0.0000000254) return "inch";
if (d==0.0000000001) return "A";*/
QString s;
s.setNum(d);
s=s+" m";
return s;
}

void layout::setUserunits(QString s){
double d=0;
if (s=="m") d=1;
if (s=="dm") d=0.1;
if (s=="cm") d=0.01;
if (s=="mm") d=0.001;
if (s=="inch") d=0.0254;
if (s=="m") d=0.000001;
if (s=="mils") d=0.0000254;
if (s=="nm") d=0.000000001;
if (s=="inch") d=0.0000000254;
if (s=="A") d=0.0000000001;
if (d==0){
  s.remove("m");
  d=s.toDouble();
}
if (d!=0)
  drawing->userunits=drawing->databaseunits/d;
//printf("%9.9f\n",d);
/*if (d==1.0) return "m";
if (d==0.1) return "dm";
if (d==0.01) return "cm";
if (d==0.001) return "mm";
if (d==0.0254) return "inch";
if (d==0.000001) return "m";
if (d==0.0000254) return "mils";
if (d==0.000000001) return "nm";
if (d==0.0000000254) return "inch";
if (d==0.0000000001) return "A";*/
}

void layout::chooseUserunits(){
  setUserunit a(getUserunits());
  if (a.exec()){
    setUserunits(a.result);
  }
}

void layout::showExtraction(){
#ifdef extractionutility
extractionTool->dock->show();
#endif
}

void layout::selectCellref(){
  setup::ngpl();
  //bool ok;
  if (!drawing->mutexReadGuiTryLock()) return;
  QStringList list=drawing->currentCell->usedCells();
  drawing->mutexReadUnlock();
  list.sort();
  if (list.isEmpty()){
	showStatus("no cellrefs exists");
	//drawing->setCellrefMode(NULL);
	return;
  }
  QStringList sl=cellSelect::getCells(list);
  if (sl.size()>0){
     if (!drawing->mutexReadGuiTryLock()) return;
        for (int i=0;i<sl.size();i++){
	  drawing->currentCell->selectCellref(sl.at(i));
	}
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	drawing->paint();
        for (int i=0;i<sl.size();i++){
	    macroAdd("layout->drawing->currentCell->selectCellref("+sl.at(i)+");");
	}
  }
  /*
  QString cellname=QInputDialog::getItem(this,tr("Add Cellreference"),tr("Select Cell to insert"),list,0,false,&ok);
  if (ok){
        if (!drawing->mutexReadGuiTryLock()) return;
	drawing->currentCell->selectCellref(cellname);
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	drawing->paint();
	macroAdd("layout->drawing->currentCell->selectCellref("+cellname+");");
	}
	*/
}

#include "ui_placecelldialog.h"

void layout::addCellref(){
  //bool ok;
  if (!drawing->mutexReadGuiTryLock()) return;
  QStringList list=drawing->undependendCells();
  drawing->mutexReadUnlock();
  list.sort();
  if (list.isEmpty()){
	showStatus(tr("not possible, no independent cell"));
	switch( QMessageBox::information( this, tr("LayoutEditor"),
					  tr("No independent cell! Do you want to use selected elements instead?"),
					  tr("Yes"), tr("No"), QString::null,
					  0, 1 ) ) {
	case 0:
	     if (drawing->mutexChangeGuiTryLock()){
		drawing->prepareUndo();
		drawing->groupSimple();
		list=drawing->undependendCells();
		drawing->mutexChangeUnlock();
		cellsUpdate();
		drawing->recountSelect();
		drawing->paint();
		drawing->setModifyChanged();
		}
	    break;
	default: // just for sanity
	    	drawing->setCellrefMode(NULL);
		return;
	    break;
	}
  }
  if (list.isEmpty()){drawing->setCellrefMode(NULL);return;}
  if (list.size()==1) {
     //printf("%s\n",list.at(0).toAscii().data());
     drawing->setCellrefMode(drawing->findCell(list.at(0)));
     return;
     }
  QDialog di;
  Ui::placeCellDialog d;
  d.setupUi(&di);
  d.cells->clear();
  d.cells->addItems(list);
  d.cells->setSortingEnabled(true);
  d.arrayGroup->hide();
  di.show();
  int i=di.exec();
  di.hide();
  if (i==QDialog::Accepted){
	QString cellname;
	if (d.cells->selectedItems().size()>0) cellname=d.cells->selectedItems().at(0)->text();
	else cellname=list.at(0);
  //;=QInputDialog::getItem(this,tr("Add Cellreference"),tr("Select Cell to insert"),list,0,false,&ok);
  //if (ok){
	drawing->setCellrefMode(drawing->findCell(cellname));
	}
  else drawing->setCellrefMode(NULL);
}

void layout::addCellrefArray(){
 // bool ok;
  if (!drawing->mutexReadGuiTryLock()) return;
  QStringList list=drawing->undependendCells();
  drawing->mutexReadUnlock();
  list.sort();
  if (list.isEmpty()){
	showStatus(tr("not possible, no independend cell"));
	switch( QMessageBox::information( this, tr("LayoutEditor"),
					  tr("No independend cell! Do you want to use selected elements instead?"),
					  tr("Yes"), tr("No"), QString::null,
					  0, 1 ) ) {
	case 0:
	     if (drawing->mutexChangeGuiTryLock()){
		drawing->prepareUndo();
		drawing->groupSimple();
		list=drawing->undependendCells();
		drawing->mutexChangeUnlock();
		cellsUpdate();
		drawing->recountSelect();
		drawing->paint();
		drawing->setModifyChanged();
		}
	    break;
	default: // just for sanity
	    	drawing->setCellrefArrayMode(NULL);
		return;
	    break;
	}

  }
  //QString cellname=QInputDialog::getItem(this,tr("Add Array of Cellreference"),tr("Select Cell to insert"),list,0,false,&ok);
 //if (ok){
  if (list.isEmpty()){	drawing->setCellrefArrayMode(NULL); return;}
  QDialog di;
  Ui::placeCellDialog d;
  d.setupUi(&di);
  d.cells->clear();
  d.cells->addItems(list);
  d.cells->setSortingEnabled(true);
  di.show();
  int i=di.exec();
  di.hide();
  if (i==QDialog::Accepted){
	QString cellname;
	if (d.cells->selectedItems().size()>0) cellname=d.cells->selectedItems().at(0)->text();
	else cellname=list.at(0);
	drawing->setCellrefArrayMode(drawing->findCell(cellname),d.anzX->value(),d.anzY->value());
  }
  else drawing->setCellrefArrayMode(NULL);
}



void layout::newCellGui(){
  
  if (drawing->mutexChangeGuiTryLock()){
  	drawing->newCell();
	drawing->mutexChangeUnlock();
  	cellsUpdate();
  	paint();
	drawing->macroAdd("layout->newCell();");
	drawing->recountSelect();
	}

}

void layout::deleteActuellCellGui(){
  if (drawing->mutexChangeGuiTryLock()){
 	deleteActuellCell();
	drawing->recountSelect();
	drawing->mutexChangeUnlock();
 	cellsUpdate();
  	drawing->scaleFull();
  }
}

void layout::deleteActuellCell(){
if (isGuiThread()){
switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to delete this cell?"),
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 ) ) {
    case 0:
	drawing->deleteActuellCell();
	drawing->macroAdd("layout->drawing->deleteCurrentCell();");
	break;
    default: // just for sanity
	break;
    }}
else {
	drawing->deleteActuellCell();
}
}



void layout::newDoc(){
   layout *ed;
   ed= project::newLayout(viewMode);
   ed->setWindowTitle(tr("LayoutEditor"));
   ed->show();
}



void layout::nextLayout(){
  setup::ngpl();
  layout *l=project::getNextLayout(this);
  if (l==NULL) return;
  if (l==this) return;
  if (l->drawing->currentCell->cellName!=drawing->currentCell->cellName)
    l->drawing->setCellGui( drawing->currentCell->cellName);
  QPoint pos1,pos2;
  QSize size1,size2;
  pos1=pos();
  pos2=l->pos();
  if (pos1!=pos2) l->move(pos1);
  size1=size();
  size2=l->size();
  if (size1!=size2) l->resize(size1);
  double scale1,scale2;
  int x1,x2,y1,y2;
  drawing->getView(&scale1,&x1,&y1);
  l->drawing->getView(&scale2,&x2,&y2);
  if ((scale1!=scale2)||(x1!=x2)||(y1!=y2)) {
	l->drawing->setView(scale1,x1,y1);
	}
  l->drawing->setAttribute(Qt::WA_NoSystemBackground);
  l->drawing->setAttribute(Qt::WA_OpaquePaintEvent);
  l->drawing->setAutoFillBackground (false);
  l->activateWindow ();
  lower();
}
 
void layout::open(QString fn){
if (isGuiThread()){
    /*
    if (drawing->modified()){
    	switch( QMessageBox::information( this, tr("Layout"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
   	 case 0:
		save();
		break;
   	 case 1:
		break;
   	 case 2:
   	 default: // just for sanity
		return;
		break;}}
    if ( !fn.isEmpty() ){
	drawing->openFile( fn );
	filename=fn;
	setTitle( fn );
    if (lastFiles!=NULL)lastFiles->add(fn);
        statusBar()->showMessage( tr("Loaded %1").arg(fn)+" "+errorreport::getLastRangString(), 2000 );}
    else
	statusBar()->showMessage( tr("Loading aborted"), 2000 );*/
    workThread->startOperation("open",fn);
    }
else {
   if (drawing->modified()) {
        workThread->dataMutex.lock();
	emit workThread->askSaveModifications();
	workThread->waitOnGui.wait(&workThread->dataMutex);
	bool saveChanges=workThread->save;
	bool cancel=workThread->cancel;
	workThread->dataMutex.unlock();
	if (cancel) return;
	if (saveChanges) save();
	}
    if ( !fn.isEmpty() ){
	drawing->openFile( fn );
	setFileName(filename,fn);
	emit workThread->setWindowTitle( filename );
	emit lastFilesAdd(fn);
        emit workThread->showMessage( tr("Loaded %1").arg(fn)+" "+errorreport::getLastRangString());}
    else
	emit workThread->showMessage( tr("Loading aborted."));
  }
}

void layout::compareCell(){
  setup::ngpl();
  bool ok;
  QStringList list;
  cellList *cell_list;
  list.clear();
  for (cell_list=drawing->firstCell;cell_list!=NULL;cell_list=cell_list->nextCell){
	if (cell_list->this_cell!=drawing->currentCell)
			list << cell_list->thisCell->cellName; 
  }
  list.sort();
  if (list.isEmpty()){
	showStatus(tr("not possible, no other cells"));
	return;
  }
  QString cellname=QInputDialog::getItem(this,tr("Compare Cell"),tr("Select Cell to be compared with the current cell. Different elements will be selected."),list,0,false,&ok);
  if (ok){
	drawing->compareCell(cellname);
	drawing->macroAdd("layout->drawing->compareCell(\""+cellname+"\");");
	drawing->paint();
	drawing->recountSelect();
	}
}

void layout::choose(){
if (isGuiThread()){
    if (drawing->modified()){
    	switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
   	 case 0:
		save();
		break;
   	 case 1:
		break;
   	 case 2:
   	 default: // just for sanity
		return;
		break;}}
    QString fn=filedialog::getOpenFileName();
    if ( !fn.isEmpty() ){
          if (filedialog::getFileType(fn)=="macro"){
		#ifdef TEXTEDIT
		textEdit *te=showTextEditor(true);
		te->open(fn);
		#endif
	  }else{
	  drawing->openFile( fn );
	  setFileName(filename,fn);
	  //filename=fn;
	  setTitle( filename );
  //	if (viewMode==viewermode) layers::disableUnusedLayers(drawing);
	  if (lastFiles!=NULL) lastFiles->add(fn);
	  statusBar()->showMessage( tr("Loaded %1").arg(fn)+" "+errorreport::getLastRangString(), 2000 );
    }}
    else
	statusBar()->showMessage( tr("Loading aborted."), 2000 );}
else {
   if (drawing->modified()) {
        workThread->dataMutex.lock();
	emit workThread->askSaveModifications();
	workThread->waitOnGui.wait(&workThread->dataMutex);
	bool saveChanges=workThread->save;
	bool cancel=workThread->cancel;
	workThread->dataMutex.unlock();
	if (cancel) return;
	if (saveChanges) save();
	}
   workThread->dataMutex.lock();
   emit workThread->askOpenFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
    if ( !fn.isEmpty() ){
          if (filedialog::getFileType(fn)=="macro"){
		#ifdef TEXTEDIT
		textEdit *te=showTextEditor(true);
		te->open(fn);
		#endif
	  }else{
	drawing->openFile( fn );
	setFileName(filename,fn);
	//filename=fn;
//	if (viewMode==viewermode) layers::disableUnusedLayers(drawing);
	emit workThread->setWindowTitle( filename );
	emit lastFilesAdd(fn);
        emit workThread->showMessage( tr("Loaded %1").arg(fn)+" "+errorreport::getLastRangString());}}
    else
	emit workThread->showMessage( tr("Loading aborted."));
  }
}
	
void layout::chooseImport(){
if (isGuiThread()){
    QString fn=filedialog::getOpenFileName();
    if ( !fn.isEmpty() ){
	drawing->importFile( fn );
        statusBar()->showMessage( tr("Imported %1").arg(fn)+" "+errorreport::getLastRangString(), 2000 );}
    else
	statusBar()->showMessage( tr("Import aborted."), 2000 );
	}
else {
   workThread->dataMutex.lock();
   emit workThread->askOpenFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
    if ( !fn.isEmpty() ){
	drawing->importFile( fn );
        emit workThread->showMessage( tr("Imported %1").arg(fn)+" "+errorreport::getLastRangString());}
    else
	emit workThread->showMessage( tr("Import aborted."));
  }
}

void layout::chooseUpdate(){
if (isGuiThread()){
    QString fn=filedialog::getOpenFileName();
    if ( !fn.isEmpty() ){
	drawing->updateFile( fn );
        statusBar()->showMessage( tr("Updated %1").arg(fn)+" "+errorreport::getLastRangString(), 2000 );}
    else
	statusBar()->showMessage( tr("Loading aborted."), 2000 );
	}
else {
   workThread->dataMutex.lock();
   emit workThread->askOpenFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
    if ( !fn.isEmpty() ){
	drawing->updateFile( fn );
        emit workThread->showMessage( tr("Updated %1").arg(fn)+" "+errorreport::getLastRangString());}
    else
	emit workThread->showMessage( tr("Update aborted."));
  }
}

void layout::save(){
   if ( filename.isEmpty() ) {
	saveAs();
	return;}
   drawing->saveFile(filename);
   emit drawing->showMessage( tr( "File %1 saved." ).arg( filename ));
   //statusBar()->showMessage( tr( "File %1 saved" ).arg( filename ), 2000 );
}


void layout::setFileName(QString oldName,QString newName){
if (oldName=="") {
	filename=newName;
	return;
	}
  QString type=filedialog::getFileType(newName);
  if ((type=="svg")||(type=="csv")||(type=="pixel")
  ||(type=="ps")||(type=="eps")||(type=="bundle.layout")){
	filename=oldName;
	return;
	}
  else filename=newName;
  return;

}

void layout::saveAs(){
if (isGuiThread()){
    QString fn = filedialog::getSaveFileName();
    if ( !fn.isEmpty() ) {
	QString old=filename;
	filename = fn;
	drawing->macroAdd("layout->filename=\""+fn+"\";");
	setTitle( filename );
	save();
	setFileName(old,fn);
	setTitle( filename );
	if (lastFiles!=NULL) lastFiles->add(fn);
    } else 
	statusBar()->showMessage( tr("Saving aborted."), 2000 );
    }
else {
   workThread->dataMutex.lock();
   emit workThread->askSaveFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
    if ( !fn.isEmpty() ){
	QString old=filename;
	filename = fn;
        drawing->macroAdd("layout->filename=\""+fn+"\";");
	emit workThread->setWindowTitle( filename );
	save();
	setFileName(old,fn);
	emit workThread->setWindowTitle( filename );
	emit lastFilesAdd(filename);
	}
    else
	emit workThread->showMessage( tr("Saving aborted."));
  }
}

void layout::print(){
if (isGuiThread()){
    initPrinter();
    QPrintDialog dialog(printer, this);
    if (dialog.exec()){
    //if ( printer->setup(this) ) {		// printer dialog
	statusBar()->showMessage( tr("Printing...") );
	drawing->print(printer);
	statusBar()->showMessage( tr("Printing completed."), 2000 );
    } else {
	statusBar()->showMessage( tr("Printing aborted."), 2000 );
    }}
else {  
   	workThread->dataMutex.lock();
   	emit workThread->askPrint();
  	workThread->waitOnGui.wait(&workThread->dataMutex);
   	workThread->dataMutex.unlock();
        if (workThread->print){
		emit workThread->showMessage(tr("Printing..."));
		initPrinter();
		drawing->print(printer);
		emit workThread->showMessage(tr("Printing completed"));
	}
    }
}

void layout::chooseGui(){
#ifndef multithread
  if (drawing->mutexChangeGuiTryLock()) {
  choose();
  drawing->mutexChangeUnlock();
  cellsUpdate();
  drawing->paint();
  }
#else
  workThread->startOperation("openFile","");
#endif
}

void layout::chooseImportGui(){
setup::ngpl();
#ifndef multithread
   if (drawing->mutexChangeGuiTryLock()) {
  chooseImport();
  drawing->mutexChangeUnlock();
  cellsUpdate();
  drawing->paint();
  }
#else
  workThread->startOperation("importFile","");
#endif
 
}

void layout::openImportGui(){
	if (QApplication::keyboardModifiers ()==Qt::ShiftModifier) chooseImportGui();
	else chooseGui();
}

void layout::openImportUpdateGui(){
	if (QApplication::keyboardModifiers ()==Qt::ShiftModifier) chooseImportGui();
	else if (QApplication::keyboardModifiers ()==Qt::ControlModifier) chooseUpdateGui();
	else chooseGui();
}

void layout::chooseUpdateGui(){
setup::ngpl();
#ifndef multithread
  if (drawing->mutexChangeGuiTryLock()) {
  chooseUpdate();
  drawing->mutexChangeUnlock();
  cellsUpdate();
  drawing->paint();
  }
#else
  workThread->startOperation("updateFile","");
#endif
  
}

void layout::saveGui(){
#ifdef LIBCHECK
#include "../liblayout/libcheck.cpp"
if (!libCheckResult) {}
else 
#endif
#ifndef multithread
  if (drawing->mutexReadGuiTryLock()) {
  	save();
  	drawing->mutexReadUnlock();
  }
#else
  workThread->startOperation("saveFile","");
#endif
 
}

void layout::saveAsGui(){
#ifdef LIBCHECK
#include "../liblayout/libcheck.cpp"
if (!libCheckResult) {}
else 
#endif
#ifndef multithread
   if (drawing->mutexReadGuiTryLock()) {
  saveAs();
  drawing->mutexReadUnlock();}
#else
  workThread->startOperation("saveAsFile","");
#endif
 
}

void layout::noSaveMessage(){
  QString s;
s= tr("<b>A license key is required!</b>");
s+=tr("<br><br>Saving of the layout is disabled after using a non free feature.");
s+=tr("<br><br>You can become a sponsor of a feature to make it free to everyone.");

 //  QMessageBox::about( this, tr("LayoutEditor"),s);
	QMessageBox msgBox;
	QPushButton *donateButton = msgBox.addButton(tr("Buy License"),
	QMessageBox::ActionRole);
	QPushButton *nodonateButton = msgBox.addButton(tr("OK"),
	QMessageBox::ActionRole);
	//QPushButton *abortButton = msgBox.addButton(QMessageBox::Ok);
	msgBox.setText(s);
	msgBox.setWindowTitle(tr("LayoutEditor"));
	msgBox.setIconPixmap(QPixmap(":/layoutIcon"));
	msgBox.exec();
	
	if (msgBox.clickedButton() == donateButton) {
	QUrl url;
	url=QUrl(HOMEPAGE_BUY);
	QDesktopServices::openUrl(url);
	} else if (msgBox.clickedButton() == nodonateButton) {
	}
}

void layout::saveAsSaveGui(){
	if (QApplication::keyboardModifiers ()==Qt::ShiftModifier) saveAsGui();
	else saveGui();
}

void layout::printGui(){
#ifndef multithread
 if (drawing->mutexReadGuiTryLock()) {
  print();
  drawing->mutexReadUnlock();}
#else
  workThread->startOperation("print","");
#endif
}



void layout::setStatusBarSize(int width){
   if (width<700) {if (gridStatus!=NULL) gridStatus->setSmall();}
   else {if (gridStatus!=NULL)gridStatus->setNormal();}
   if (timeStatus!=NULL) {
	if (width<1000) timeStatus->setOff();
	else timeStatus->setNormal();
	}
   if (selectStatus!=NULL){
   	if (width<520) selectStatus->setOff();
   	else if (width<620) selectStatus->setSmall();
   	else if (width<900)selectStatus->setNormal();
   	else if (width<1200)selectStatus->setWide();
   	else selectStatus->setExtraWide();}
   if (width<650) {if (posStatus!=NULL) posStatus->setSmall();}
   else if (width<750){if (posStatus!=NULL)posStatus->setNormal();}
   else {if (posStatus!=NULL)posStatus->setWide();}
}
    
void layout::resizeEvent ( QResizeEvent * e ){
 // printf("layout resizeEvent\n");
    QMainWindow::resizeEvent ( e );
    setStatusBarSize(e->size().width());
 // printf("layout resizeEvent end\n");
}

void layout::closeEvent( QCloseEvent* ce ){
if (layout::debug) printf("layout closeEvent\n");
    setup::saveSettings(this);
    if ( !drawing->modified() ) {
	project::closeLayout(this);
	ce->accept();
	return; }
    switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
    case 0:
	workThread->wait();
	drawing->mutexChangeLock();
	save();
	drawing->mutexChangeUnlock();
	project::closeLayout(this);
	ce->accept();
	break;
    case 1:
	drawing->mutexChangeLock();
	drawing->mutexChangeUnlock();
	workThread->abortOperation();
	project::closeLayout(this);
	ce->accept();
	break;
    case 2:
    default: // just for sanity
	ce->ignore();
	break;
    }
if (layout::debug)  printf("layout closeEvent end\n");
}


void layout::closeDesignGui(){
setup::ngpl();
   if ( !drawing->modified() ) {
	closeDesign();
	drawing->paint();
	cellsUpdate();
	return; }
    switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
    case 0:
	workThread->wait();
	drawing->mutexChangeLock();
	save();
	drawing->mutexChangeUnlock();
	closeDesign();
	break;
    case 1:
	drawing->mutexChangeLock();
	drawing->mutexChangeUnlock();
	workThread->abortOperation();
	closeDesign();
	break;
    case 2:
    default: // just for sanity
	break;
    }
    drawing->paint();
    cellsUpdate();
}

void layout::closeDesign(){
  filename="";
  emit workThread->setWindowTitle(filename);
  drawing->deleteAllCell();
  drawing->addCell();
  drawing->currentCell=drawing->firstCell->thisCell;
  drawing->currentCell->cellName="noname";
  drawing->setModifySaved();
  drawing->userunits=0.001;
  drawing->databaseunits=0.000000001;
  drawing->libname="noname";
  drawing->macroAdd("layout->closeDesign();");
}

void layout::emitNewCurrentCell(const QString &s){emit newCurrentCell(s);};

void layout::cellsUpdate(){
  if (cellcombo==NULL) {
     if (drawing->mutexReadTryLock()) {
	QStringList list;
	cellList *e=drawing->firstCell;
	list.append(e->thisCell->cellName);
	while ((e->next_cell!=NULL)){
		e=e->next_cell;
		list.append(e->thisCell->cellName);
		}
	list.sort();
	QString currentCell=drawing->currentCell->cellName;
	QString newCell=drawing->currentCell->cellName;
	drawing->mutexReadUnlock();
	emit cellsChanged(list,currentCell);
	emitNewCurrentCell(newCell);
    }
    return;
  }
  if (drawing->mutexReadTryLock()) {
	QString oldCell=cellcombo->currentText();
	cellcombo->clear();
	QStringList list;
	cellList *e=drawing->firstCell;
	list.append(e->thisCell->cellName);
	while ((e->next_cell!=NULL)){
		e=e->next_cell;
		list.append(e->thisCell->cellName);
		}
	list.sort();
	cellcombo->insertItems(0,list);
	cellcombo->setCurrentIndex(cellcombo->findText(drawing->currentCell->cellName));
	QString currentCell=drawing->currentCell->cellName;
	QString newCell=drawing->currentCell->cellName;
	drawing->mutexReadUnlock();
	emit cellsChanged(list,currentCell);
	if (oldCell!=newCell) emitNewCurrentCell(newCell);
  }
}

void layout::currentCellUpdate(){
  if (cellcombo==NULL) {
    if (drawing->mutexReadTryLock()) {
      QString currentCell=drawing->currentCell->cellName;
      drawing->mutexReadUnlock();
      emitNewCurrentCell(currentCell);
    }
    return;
  }
  if (drawing->mutexReadTryLock()) {
	QString oldCell=cellcombo->currentText();
	QString newCell=drawing->currentCell->cellName;
	drawing->mutexReadUnlock();
	if (oldCell!=newCell) {
	  setCellCombo(newCell);
	  emitNewCurrentCell(newCell);
	}
  }
}

void layout::setCellCombo(QString s){
  if (cellcombo==NULL) return;
  cellcombo->setCurrentIndex(cellcombo->findText(s));
}

void layout::setCell(){
  if (isGuiThread()){
   		selectCell b(drawing);
		b.show();
		int i=b.exec();
		b.hide();
		switch (i) {
		case QDialog::Rejected :
		    return ;
		case QDialog::Accepted :
			    drawing->setCell(b.result);
		    drawing->macroAdd("layout->drawing->setCell(\""+b.result+"\");");
		    return ;
		}
		return;
		}
	else {
		workThread->dataMutex.lock();
   		emit workThread->askCell();
   		workThread->waitOnGui.wait(&workThread->dataMutex);
		QString cell=workThread->text;
  		workThread->dataMutex.unlock();
		drawing->setCell(cell);
		}
}

void layout::setCellGui(){  
   //drawing->setCursor(QCursor(Qt::ForbiddenCursor));
   selectCell b(drawing);
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
	//drawing->setCursor(QCursor(Qt::BlankCursor));
    	return ;
    case QDialog::Accepted :
    		drawing->setCellGui(b.result);
		drawing->setFocus();
        drawing->macroAdd("layout->drawing->setCell(\""+b.result+"\");");
	//drawing->setCursor(QCursor(Qt::BlankCursor));
	return ;
    }
    //drawing->setCursor(QCursor(Qt::BlankCursor));
    return;
}

void layout::setCellnameGui(){
  if (drawing->mutexAddGuiTryLock()){
  	setCellname();
	drawing->mutexAddUnlock();
	cellsUpdate();
	}
}

void layout::setCellname(){
if (isGuiThread()){
  bool b;
  QString s=QInputDialog::getText(this,tr("Cell Name"),tr("Enter Cell Name"),QLineEdit::Normal,drawing->currentCell->cellName,&b);
  if (b&&!s.isEmpty()) {
    if (!drawing->existCellname(s)){
	drawing->currentCell->cellName=s;
	drawing->macroAdd("layout->drawing->currentCell->cellName=\""+s+"\";");
	}
  }
}
else {
   workThread->dataMutex.lock();
   emit workThread->askCellName();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   workThread->dataMutex.unlock();
   }
}
	
void layout::toggleRenderText(){
  setup::displayText=!setup::displayText;
  drawing->paint();
}

void layout::toggleShowCellRefs(){
  setup::displayCells=!setup::displayCells;
  drawing->paint();
}


void layout::moveLayer(){
setup::ngpl();
  switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to move select to aktive Layer?"),
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 ) ) {
    case 0:
        if (drawing->mutexChangeGuiTryLock()){
    		drawing->prepareUndo();
		drawing->currentCell->moveToLayerSelect(drawing->activeLayer);
		drawing->macroAdd("layout->drawing->currentCell->moveToLayerSelect(layout->drawing->activeLayer);");
		drawing->mutexChangeUnlock();
		}
	drawing->paint();
	drawing->setModifyChanged();
	break;
    default: // just for sanity
	break;
   }
}

void layout::copyLayer(){
setup::ngpl();
  switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to copy select to aktive Layer?"),
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 ) ) {
    case 0:
        if (drawing->mutexAddGuiTryLock()){
    		drawing->prepareUndo();
		drawing->currentCell->copySelect(QPoint(0,0));
		drawing->currentCell->moveToLayerSelect(drawing->activeLayer);
		drawing->macroAdd("layout->drawing->currentCell->copySelect();");
		drawing->macroAdd("layout->drawing->currentCell->moveToLayerSelect(layout->drawing->activeLayer);");
		drawing->mutexAddUnlock();
		}
    	
	drawing->paint();
	drawing->setModifyAdded();
	break;
    default: // just for sanity
	break;
   }
}

void layout::flat(){
/*  switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to flatten select cells?"),
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 ) ) {
    case 0:*/
	if (drawing->mutexChangeGuiTryLock()){
		drawing->prepareUndo();
		drawing->currentCell->flatSelect();
		drawing->setModifyChanged();
		drawing->macroAdd("layout->drawing->flat();");
		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		drawing->paint();
		}
/*	break;
    default: // just for sanity
	break;
  }*/
}

void layout::flatAll(){
/*  switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to (multilevel) flatten select cells?"),
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 ) ) {
    case 0:*/
	if (drawing->mutexChangeGuiTryLock()){
		drawing->prepareUndo();
		drawing->currentCell->flatAllSelect();
		drawing->setModifyChanged();
		drawing->macroAdd("layout->drawing->flatAll();");
		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		drawing->paint();
		}
/*	break;
    default: // just for sanity
	break;
  }*/
}

void layout::extractCell(){
setup::ngpl();
}

void layout::stripUnneeded(){
setup::ngpl();
}

void layout::stripEmptyCells(){
}

void layout::removeCellArrays(){
}

void layout::removeNotOrthogonalCellref(){
}

void layout::removeScaledCellref(){
}


 void layout::stripIdenticalElements(){
}

void layout::extractLayer(){
}

#include "ui_flatdialog.h"
#include "ui_groupdialog.h"

void layout::flatDialogGui(){
setup::ngpl();
  QDialog di;
  Ui::flatDialog d;
  d.setupUi(&di);
  di.show();
  int i=di.exec();
  di.hide();
  if (i==QDialog::Accepted){
	int i=d.level->value();
	if (i==0) flatAll();
	else {
	  for (int k=0;k<i;k++){flat();}
	}
	}

}

void layout::groupDialogGui(){
setup::ngpl();
  QDialog di;
  Ui::groupDialog d;
  d.setupUi(&di);
  di.show();
  int i=di.exec();
  di.hide();
  if (i==QDialog::Accepted){
	if (d.groupSimple->isChecked()){
	  groupSimpleGui();
	}
	if (d.group->isChecked()){
	  groupGui();
	}
	if (d.groupStructure->isChecked()){
	  groupStructureGui();
	}
	if (d.groupGlobal->isChecked()){
	  groupGlobalGui();
	}
	}

}

void layout::groupGui(){
setup::ngpl();
  if (drawing->mutexChangeGuiTryLock()){
  	drawing->prepareUndo();
  	drawing->group();
	drawing->mutexChangeUnlock();
	drawing->macroAdd("layout->drawing->group();");
	cellsUpdate();
	drawing->recountSelect();
  	drawing->paint();
  	drawing->setModifyChanged();
	}
}

void layout::groupSimpleGui(){
setup::ngpl();
}

void layout::groupStructureGui(){
setup::ngpl();
}

void layout::groupGlobalGui(){
setup::ngpl();
}

void layout::group(){
  drawing->group();
}

void layout::screenshot(){
if (isGuiThread()){
QStringList filter;
QStringList png;
for (int i=0;i<QImageWriter::supportedImageFormats ().count();i++){
   QString f=QImageWriter::supportedImageFormats ().at(i);
   if (f!="png") {
	png <<f + " (*." + f.toLower() + " *." + f.toUpper() + ")";}
   else {
   	filter <<  f + " (*." + f.toLower() + " *." + f.toUpper() + ")";
	}
   }
    //printf("%s\n",QString(QImageIO::outputFormats().at(i)).latin1());}
 filter+=png;
 QFileDialog file;
 file.setAcceptMode ( QFileDialog::AcceptSave);
 if (filedialog::getLastPath()!="") file.setDirectory(filedialog::getLastPath());
 file.setWindowTitle(tr("screenshot save dialog"));
 file.setFilters(filter);
 file.setViewMode(QFileDialog::List);
 file.show();
 int k=file.exec();
 if (k==QDialog::Accepted) {
        QStringList files = file.selectedFiles();
        QString fn;
	filedialog::setLastPath(file.directory().absolutePath());
        if (!files.isEmpty()) {
	  fn = files[0];
	  QString ext=file.selectedFilter();
	  ext=ext.left(ext.indexOf (" ",0));
	  //printf("(%s)%d\n",ext.toAscii().data(),fn.toUpper().indexOf("."+ext.toUpper(),0));
	  if (fn.toUpper().indexOf("."/*+ext.toUpper()*/,0)==-1) {fn+="."+ext.toLower();}
	  saveScreenshot(fn);
	  drawing->macroAdd("layout->drawing->screenshot("+fn+");");
	}
	/*QString ext=file.selectedFilter();
	ext=ext.left(ext.indexOf (" ",0));
	if (fn.toUpper().indexOf("."+ext.toUpper(),0)==-1) {fn+="."+ext.toLower();}
	drawing->forcePaint();
  	QPixmap p=drawing->pixmap->getPixmap();
  	p.save(fn,ext.toLatin1(),-1);*/
 	}
 else statusBar()->showMessage( tr("Saving aborted."), 2000 );
}
else {
   workThread->dataMutex.lock();
   emit workThread->askScreenshot();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
   if (fn!="") saveScreenshot(fn);
}
}

void layout::screenshotGui(){
  if (drawing->mutexReadGuiTryLock()) {
  screenshot();
  drawing->mutexReadUnlock();}
}


void layout::aktiveLayerChange(int nr){
  if (nr!=drawing->activeLayer) {
  if (layerTools!=NULL)  if (drawing->activeLayer<layerTools->initLayers) layerTools->button[drawing->activeLayer]->aktiveOff();
  drawing->activeLayer=nr;
  drawing->macroAdd("layout->drawing->activeLayer="+drawing->str(nr)+";");}
}

void layout::updateLayerbutton(){
  if (layerTools==NULL)return;
   for (int i=0;i<layerTools->initLayers;i++){
	layerTools->button[i]->updateButton();
	}
}

void layout::updateSetupLayerbutton(){
  if (layerTools==NULL)return;
  for (int i=0;i<layerTools->initLayers;i++){
	layerTools->button[i]->active=false;
	}
  if (drawing->activeLayer<layerTools->initLayers) layerTools->button[drawing->activeLayer]->active=true;
  layerTools->updateAllButtons();
}



void layout::debugOnOff(){
   if (layout::debug) {debug=false;
      }
   else {debug=true;
      }
}

void layout::cleanElements(){
if (drawing->mutexChangeGuiTryLock()){
   drawing->prepareUndo();
   //drawing->setCursor(QCursor(Qt::ForbiddenCursor));
   drawing->currentCell->cleanElements();
   drawing->currentCell->clean();
   drawing->mutexChangeUnlock();
   drawing->paint();
   drawing->emitSelectChange(drawing->currentCell->countSelect());
   drawing->setModifyChanged();
   //drawing->setCursor(QCursor(Qt::BlankCursor));
  }
}



void layout::toggleMenu(){
  if (menuBar()->isVisible()){menuBar()->hide();}
  else {menuBar()->show();}
}


void layout::areaSelect(){
setup::ngpl();
}

void layout::showMenuBar(){
 menuBar()->show();
}
void layout::hideMenuBar(){
menuBar()->hide();
}

bool layout::isMenuBarVisible(){
return menuBar()->isVisible();
}


void layout::windowActivationChange ( bool oldActive ){
//printf("layout activeEvent\n");
//#ifndef Q_OS_DARWIN
  if (isActiveWindow()) updateSetupLayerbutton();
//#endif
if (lastFiles!=NULL) lastFiles->update();
QMainWindow::windowActivationChange (oldActive );
//printf("layout activeEvent end\n");
}

void layout::editMacroGui(){
setup::ngpl();
		#ifdef TEXTEDIT
		textEdit *te=showTextEditor(true);
		te->open(fn);
		#endif
		/*#ifdef TEXTEDIT
		textEdit *te=new textEdit();
		//te->setWindowTitle( "TextEditor" );
		te->open(fn);
		#endif
		#ifdef PYTHON
		te->setDefaultGui();
		#endif
		#ifdef TEXTEDIT
		te->toolBarAdd(tr("Exec"),"6000");
		te->show();
		connect(te,SIGNAL(execute(QString)),this,SLOT(execute2Macro(QString)));
		#endif*/
}

void layout::executeMacroGui(){
setup::ngpl();
}

int layout::executeMacro(QString fileName,QString parameter){
#ifdef OPENACCESS
if (fileName.right(4)==".tcl") return tclInterpreter::execFile(fileName);
#endif
#ifdef PYTHON
if (fileName.right(3)==".py") {callPythonFile(fileName);return 0;}
#endif
 return 1;

}

int layout::executeMacroForce(QString fileName,QString parameter){
#ifdef OPENACCESS
if (fileName.right(4)==".tcl") return tclInterpreter::execFile(fileName);
#endif

}


void layout::macroStart(QString fileName,QString name){
  if (debug) printf("start macro :'%s'\n",name.toAscii().data());
//start macro from macro menu entry
#ifndef multithread
    if (drawing->mutexChangeGuiTryLock()) {
	drawing->autorepaint=false;
	bool macrorecord=drawing->record;
	drawing->record=false;
	macro m;
	errorreport error;
	QString s="Executing Macro \""+name+"\" ("+fileName+").";
	error.setTitle(s);
	m.load(&fileName);
	m.setLayout(this);
	int ret=1;
	ret=m.execute(&error);
	if (ret!=0) {error.addItem(tr("main function exit code: ")+s.setNum(ret),2);}
	error.showReport();
	drawing->autorepaint=true;
	setWindowTitle( filename );
	if (macrorecord) drawing->record=true;
	//mainWindow->drawing->macroAdd("// Execute of macro \""+name+"\" ("+fileName+"). A macro cannot start another macro.");
	drawing->macroAdd("layout->executeMacro(\""+fileName+"\");");
	drawing->recountSelect();
	drawing->mutexChangeUnlock();
	drawing->firstCell->paintInfoClear();
	updateSetupLayerbutton();
	cellsUpdate();
	updateGrid();
	drawing->setModifyChanged();
	drawing->paint();
#ifdef USE_3d
	if (view3dTool!=NULL) view3dTool->trigger3dProcess();
#endif
	}
#else
	workThread->startOperation("macro",fileName);
#endif

}

void layout::guiUpdate(){
  emit updateGui();
  emit workThread->setWindowTitle( filename );
  emit workThread->updateSetupLayerbutton();
  emit workThread->cellsUpdate();
  emit workThread->updateGrid();
#ifdef USE_3d
  emit workThread->trigger3dProcessRequest();
#endif 
}

void layout::toMeshSelect(){
}



void layout::sizeadjustSelect(){
setup::ngpl();
}

void layout::roundSelect(){
setup::ngpl();
}

void layout::snapShapesSelect(){
setup::ngpl();
}

void layout::edgeRemoveSelect(){
setup::ngpl();
}

void layout::cropSharpAnglesSelect(){
setup::ngpl();
}



void layout::generateTechnologyMacro(){
}


void layout::generate3dSetupMacro(){
#ifdef USE_3d
 QString fn= QFileDialog::getSaveFileName(this,  tr("Generate 3d Setup Macro: Choose Filename"),  QDir::homePath(), "*"); 
  if ( !fn.isEmpty() ) {
        if (!fn.contains(".")) fn+=".layout";
	layers::write3dSetupMacro(fn);
	updateMacros();
	statusBar()->showMessage( tr("Macro generated."), 2000 );
    } else 
	statusBar()->showMessage( tr("Aborted."), 2000 );
#endif
}


void layout::generateViewMacro(){
}

void layout::stopMacroRecording(){
}

void layout::startMacroRecording(){
     drawing->startMacroRecording();
     multiButton[macroMultiButton]->set(1);
}

void  layout::moveBy(){
setup::ngpl();
    moveby b(drawing->userunits);
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
    	return ;
    case QDialog::Accepted :
	if (drawing->mutexChangeGuiTryLock()){
    		drawing->prepareUndo();
    		drawing->currentCell->moveSelect(QPoint(element::round(b.moveX->text().toDouble()/drawing->userunits),element::round(b.moveY->text().toDouble()/drawing->userunits)));
		drawing->macroAdd("layout->drawing->point("+drawing->str(QPoint(element::round(b.moveX->text().toDouble()/drawing->userunits),element::round(b.moveY->text().toDouble()/drawing->userunits)))+");");
		drawing->macroAdd("layout->drawing->move();");
		drawing->mutexChangeUnlock();
		drawing->setModifyChanged();
		}
    	drawing->paint();
	return ;
    }
    return;
}

void  layout::copyBy(){
setup::ngpl();
    moveby b(drawing->userunits);
    b.setWindowTitle(tr("Copy By"));
    b.groupBox->setTitle(tr("Copy Movement"));
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
    	return ;
    case QDialog::Accepted :
	if (drawing->mutexChangeGuiTryLock()){
    		drawing->prepareUndo();
    		drawing->currentCell->copySelect(QPoint(element::round(b.moveX->text().toDouble()/drawing->userunits),element::round(b.moveY->text().toDouble()/drawing->userunits)));
		drawing->macroAdd("layout->drawing->point("+drawing->str(QPoint(element::round(b.moveX->text().toDouble()/drawing->userunits),element::round(b.moveY->text().toDouble()/drawing->userunits)))+");");
		drawing->macroAdd("layout->drawing->copy();");
		drawing->mutexChangeUnlock();
		drawing->setModifyAdded();
		}
    	drawing->paint();
	return ;
    }
    return;
}

void layout::gotoxy(){
    int x,y;
    double x_,y_;
    double scale;
    int dim;
    drawing->getView(&scale,&x,&y);
    x_=-(double(x)-double(drawing->width()/2)/scale)*drawing->userunits;
    y_=(double(y)-double(drawing->height()/2)/scale)*drawing->userunits;
    dim=drawing->width();
    if (drawing->width()>drawing->height()) dim=drawing->height();
    scale=1.0/scale*dim*drawing->userunits;
    gotoXY b(drawing->userunits);
    QString s;
    double h=drawing->userunits;
    int dig=0;
    while (h<1) {h=h*10;++dig;}
    s.setNum(x_,'f',dig);
    b.posX->setText(s);
    s.setNum(y_,'f',dig);
    b.posY->setText(s);
    dig=0;h=scale;
    while (h<100) {h=h*10;++dig;}
    s.setNum(scale,'f',dig);
    b.scale->setText(s);
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
    	return ;
    case QDialog::Accepted :
	if (drawing->mutexChangeGuiTryLock()){
    		scale=b.scale->text().toDouble()/drawing->userunits/dim;
		if (scale>0) scale=1.0/scale;
		x_=b.posX->text().toDouble()/drawing->userunits;
		y_=b.posY->text().toDouble()/drawing->userunits;
		x=element::runden(-x_+double(drawing->width()/2)/scale);
		y=element::runden(y_+double(drawing->height()/2)/scale);
		drawing->setView(scale,x,y);
    		QString x1,y1,s1;
		x1.setNum(x);
		y1.setNum(y);
		s1.setNum(scale,'g',10);
		drawing->macroAdd("layout->drawing->setView("+s1+","+x1+","+y1+");");
		drawing->mutexChangeUnlock();
		}
    	drawing->paint();
	return ;
    }
    return;
}

void layout::modifyCorners(){
setup::ngpl();
}




void layout::hideToolBar(QString name){
  if (name=="Mousehelp") if (mouseHelps!=NULL) mouseHelps->hide();
for (int i=0;i<=toolBarNext;i++){
	if (toolBar[i]->windowTitle()==name){
		toolBar[i]->hide();
		return;
		}
	}
}

void layout::showToolBar(QString name){
  if (name=="Mousehelp") if (mouseHelps!=NULL) mouseHelps->show();
for (int i=0;i<=toolBarNext;i++){
	if (toolBar[i]->windowTitle()==name){
		toolBar[i]->show();
		return;
		}
	}
}

void layout::toolBarAdd(QString name,QString buttons ){
   
QList<int> list;
QMap<QString,int> map;
QString textLabel;
QObject *receiver;
const char * slot;
helpText helptext;
for (int i=1000;i<2500;i++){
	getFunctionInfo(i,&textLabel,&receiver,&slot,&helptext);
	if ((textLabel!="")&&(textLabel!="no function")){
		map[textLabel]=i;
		//printf("%d %s\n",i,textLabel.toAscii().data());
		}
	}
map["Cell Select"]=11001;
QStringList sl=buttons.split(";");
for (int i=0;i<sl.size();i++){
	int n=map[sl.at(i).trimmed()];
	if (n==0){
	  n=sl.at(i).toInt();
	}
	list<<n;
	}
addToolbar(name,list);
}

void layout::menuAdd(QString name,QString entries ){
     
QList<int> list;
QMap<QString,int> map;
QString textLabel;
QObject *receiver;
const char * slot;
helpText helptext;
for (int i=1000;i<2500;i++){
	getFunctionInfo(i,&textLabel,&receiver,&slot,&helptext);
	if ((textLabel!="")&&(textLabel!="no function")){
		map[textLabel]=i;
		//printf("%d %s\n",i,textLabel.toAscii().data());
		}
	}
map["Last Opened"]=12000;
map["Release Notes"]=12003;
QStringList sl=entries.split(";");
for (int i=0;i<sl.size();i++){
	int n=map[sl.at(i).trimmed()];
	if (n==0){
	  n=sl.at(i).toInt();
	}
	if ((i==0)&&(sl.at(i).toInt()>=0)) list<<0;
	list<<n;
	}
addMenu(name,list);
}

void layout::drcGrid(){
setup::ngpl();
  bool b;
  double d=QInputDialog::getDouble(this,tr("DRC: On Grid"),tr("Enter Grid:"),0,0,1000000,6,&b);
  if (b) {
	d=d/drawing->userunits;
	int i=element::round(d);
	drcTool->setRuleName("On Grid "+drawing->str(drawing->activeLayer));
	if (isGuiThread()){
  		workThread->startOperation("drcOnGrid","","",i,drawing->activeLayer);
 	}
	else{
	if ( drawing->mutexChangeGuiTryLock()){
		drcTool->onGrid(i,drawing->activeLayer);
		drawing->mutexChangeUnlock();
		drcTool->updateGui();
	}
	}
  }
}

void layout::drcMinSize(){
setup::ngpl();
}

void layout::drcMinOverlap(){
setup::ngpl();
}

void layout::drcMinDistance(){
setup::ngpl();
}

void layout::drcMinDistanceOrOverlap(){
setup::ngpl();
}


void layout::drcMinElementDistance(){
setup::ngpl();
}


void layout::drcInside(){
setup::ngpl();
}

void layout::drcLayerCombination(){
setup::ngpl();
}

void layout::drcEnclosure(){
setup::ngpl();
}
void layout::drcOverlapDistance(){
setup::ngpl();
}


void layout::drcNoHoles(){
setup::ngpl();
}

void layout::drcArea(){
setup::ngpl();
}

void layout::drcPerimeter(){
setup::ngpl();
}

void layout::drcDimension(){
setup::ngpl();
}

void layout::drcAngles(){
setup::ngpl();
}


void layout::drcNotches(){
setup::ngpl();
}

void layout::copyCurrentCell(){
   if( drawing->mutexChangeGuiTryLock()){
		drawing->prepareUndo();
		drawing->copyCurrentCell();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		macroAdd("layout->drawing->copyCurrentCell();");
		cellsUpdate();
		paint();
   		}
}

void layout::toPolygon(){
  if( drawing->mutexChangeGuiTryLock()){
  		drawing->prepareUndo();
  		drawing->toPolygon();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		macroAdd("layout->drawing->toPolygon();");
		paint();
   		}
}

void layout::closedPathToPolygon(){
}

void layout::toBox(){
  if( drawing->mutexChangeGuiTryLock()){
  		drawing->prepareUndo();
  		drawing->toBox();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		macroAdd("layout->drawing->toBox();");
		paint();
   		}
}

void layout::toCircle(){
}

void layout::deleteSelect(){
  if( drawing->mutexChangeGuiTryLock()){
  		drawing->prepareUndo();
  		drawing->deleteSelect();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		macroAdd("layout->drawing->deleteSelect();");
		paint();
   		}
}

void layout::cropWithSelection(){
setup::ngpl();
}

void layout::mergeSelect(){
setup::ngpl();
  if (selectStatus!=NULL){
	if (selectStatus->getSelectedAreaShapes()>250){
		switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Please use the boolean tool to merge many shapes.\n"
				      	 "It has a much better performance!\n\n"
					 "Do you really want to merge the selected shapes?"),
				      tr("Yes"), tr("No"), "",
				      0, 1 ) ) {
		case 0:
			// do merge
			break;
		case 1:
			return;
			break;
		case 2:
		default: // just for sanity
			
			break;}
		}
	}
  if( drawing->mutexChangeGuiTryLock()){
  		drawing->prepareUndo();
  		drawing->mergeSelect();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		macroAdd("layout->drawing->mergeSelect();");
		paint();
   		}
}

void layout::textDeselect(){
}

void layout::textSelect(){
}

void layout::polygonDeselect(){
}

void layout::polygonSelect(){
}

void layout::boxDeselect() {
}

void layout::boxSelect(){
}

void layout::pathDeselect(){
}

void layout::pathSelect(){
}

void layout::deselectActiveLayer(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->deselectActiveLayer();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->deselectActiveLayer();");
	paint();
	}
}

void layout::selectActiveLayer(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->selectActiveLayer();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->selectActiveLayer();");
	paint();
	}
}

void layout::deselectAll(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->deselectAll();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->deselectAll();");
	paint();
	}
}

void layout::selectVisible(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->selectVisible();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->selectVisible();");
	paint();
	}
}

void layout::selectAll(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->selectAll();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->selectAll();");
	paint();
	}
}

void layout::deSelectAll(){
	if (QApplication::keyboardModifiers ()==Qt::ShiftModifier) selectVisible();
	else if(QApplication::keyboardModifiers ()==Qt::ControlModifier) deselectAll();
	else selectAll();
}

void layout::invertSelect(){
   if( drawing->mutexReadGuiTryLock()){
	drawing->invertSelect();
	drawing->recountSelect();
	drawing->mutexReadUnlock();
	macroAdd("layout->drawing->invertSelect();");
	paint();
	}
}
void layout::undo(){
if( drawing->mutexChangeGuiTryLock()){
  		drawing->undo();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		cellsUpdate();
		drawing->macroAdd("layout->drawing->undo();");
		drawing->paint();
   		}
}

void layout::redo(){
if( drawing->mutexChangeGuiTryLock()){
  		drawing->redo();
   		drawing->recountSelect();
		drawing->mutexChangeUnlock();
		drawing->macroAdd("layout->drawing->redo();");
		cellsUpdate();
		drawing->paint();
   		}
}

void layout::showGridToggle(){
  setup::showGrid = !setup::showGrid;
  drawing->paint();
}


void layout::askSaveModifications(){
   workThread->dataMutex.lock();
   workThread->save=false;
   workThread->cancel=false;
   workThread->open=false;
    	switch( QMessageBox::information( this, tr("LayoutEditor"),
				      tr("Do you want to save the changes"
				      " to the document?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) ) {
   	 case 0:
		workThread->save=true;
		break;
   	 case 1:
		break;
   	 case 2:
   	 default: // just for sanity
		workThread->cancel=true;
		break;}
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askOpenFilename(){
   workThread->dataMutex.lock();
   workThread->save=false;
   workThread->cancel=false;
   workThread->open=true;
   workThread->filename=filedialog::getOpenFileName();
    if (workThread->filename.isEmpty()){
		workThread->cancel=true;
		workThread->open=false;
		}
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askSaveFilename(){
   workThread->dataMutex.lock();
   workThread->save=true;
   workThread->cancel=false;
   workThread->open=false;
   workThread->filename=filedialog::getSaveFileName();
    if (workThread->filename.isEmpty()){
		workThread->cancel=true;
		workThread->save=false;
		}
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askPrint(){
   workThread->dataMutex.lock();
     workThread->print=true;
     workThread->cancel=false;
   initPrinter();
    QPrintDialog dialog(printer, this);
    if (!dialog.exec()){
	workThread->print=false;
     	workThread->cancel=true;
    }
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askText(QString s1,QString s2,QString s3){
   workThread->dataMutex.lock();
   workThread->text=getText(s1,s2,s3);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askDouble(QString s1,QString s2,double d, int dig){
   workThread->dataMutex.lock();
   workThread->d=getDouble(s1,s2,d,dig);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askInteger(QString s1,QString s2, int i){
   workThread->dataMutex.lock();
   workThread->integer=getInteger(s1,s2,i);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askBool(QString s1,QString s2){
   workThread->dataMutex.lock();
   workThread->integer=getBool(s1,s2);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askCell(){
   workThread->dataMutex.lock();
    selectCell b(drawing);
    b.show();
    int i=b.exec();
    b.hide();
    switch (i) {
    case QDialog::Rejected :
    	workThread->text="";
	break;
    case QDialog::Accepted :
	workThread->text=b.result;
 
    }
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askScreenshot(){
  workThread->dataMutex.lock();
  workThread->filename="";
  QStringList filter;
  QStringList png;
  for (int i=0;i<QImageWriter::supportedImageFormats ().count();i++){
     QString f=QImageWriter::supportedImageFormats ().at(i);
     if (f!="png") {
	png <<f + " (*." + f.toLower() + " *." + f.toUpper() + ")";}
     else {
   	filter <<  f + " (*." + f.toLower() + " *." + f.toUpper() + ")";
	}
     }
 filter+=png;
 QFileDialog file;
 file.setWindowTitle(tr("screenshot save dialog"));
 if (filedialog::getLastPath()!="") file.setDirectory(filedialog::getLastPath());
 file.setFilters(filter);
 file.setViewMode(QFileDialog::List);
 file.show();
 int k=file.exec();
 if (k==QDialog::Accepted) {
        QStringList files = file.selectedFiles();
	filedialog::setLastPath(file.directory().absolutePath());
        QString fn;
        if (!files.isEmpty())
		workThread->filename=files[0];
 	}
 workThread->dataMutex.unlock();
 workThread->waitOnGui.wakeOne();
}

void layout::askCellName(){
  bool b;
  workThread->dataMutex.lock();
  QString s=QInputDialog::getText(this,tr("Cell Name"),tr("Enter Cell Name"),QLineEdit::Normal,drawing->currentCell->cellName,&b);
  if (b&&!s.isEmpty()) {
    if (!drawing->existCellname(s)){
	drawing->currentCell->cellName=s;
	drawing->macroAdd("layout->drawing->currentCell->cellName=\""+s+"\";");
	}
  }
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askShowMessage(QString s1,QString s2){
   workThread->dataMutex.lock();
   showMessage(s1,s2);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();
}

void layout::askTextEditor(){
#ifdef TEXTEDIT
   workThread->dataMutex.lock();
   workThread->textEditor=showTextEditor(workThread->parameterBool);
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();

#endif
}

void layout::askSchematic(){
#ifdef SCHEMATIC
   workThread->dataMutex.lock();
   workThread->schematicWindow=createSchematic();
   workThread->dataMutex.unlock();
   workThread->waitOnGui.wakeOne();

#endif
}

void layout::clipboardCopy(){
  if (drawing->mutexReadTryLock()){
	QMimeData *mimeData = new QMimeData;
	drawing->writeMimeData(mimeData);
	QByteArray output;
	QBuffer outputBuffer(&output);
	outputBuffer.open(QIODevice::WriteOnly);
	drawing->pixmap->getImage().save(&outputBuffer, "PNG");
	mimeData->setData("image/png", output);
	QClipboard *clipboard = QApplication::clipboard();
	clipboard->setMimeData(mimeData,QClipboard::Clipboard);
	drawing->mutexReadUnlock();
  }
}

void layout::clipboardPaste(){
   if (drawing->mutexAddGuiTryLock()){
	QClipboard *clipboard = QApplication::clipboard();
	const QMimeData *mimedata=clipboard->mimeData(QClipboard::Clipboard);
	if (mimedata->hasFormat("application/layouteditor")){
		drawing->prepareUndo();
		drawing->readMimeData(clipboard->mimeData(QClipboard::Clipboard));
		drawing->paint();
		emit drawing->cellsChange();		
		drawing->recountSelect();
	}
	drawing->mutexAddUnlock();
	drawing->setModifyChanged();
    }
}



void layout::lockGuiThread(){
   lockMutex.lock();
   //printf("lock\n");
   guiLocked=true;
   lockWait.wait(&lockMutex,10000);
   //printf("unlock\n");
   lockMutex.unlock();
}

void layout::unlockGuiThread(){
   guiLocked=false;
   lockWait.wakeAll();
}



void layout::setTitle(QString s){
#ifdef OPENACCESS
   if (s.right(3)==".oa") s=drawing->libname;
#endif
   setWindowTitle(s);
#ifndef FULL_VERSION
   setWindowTitle(QString("BASIC FEATURES ONLY! ")+s);
#endif
};



void layout::keyPressEvent ( QKeyEvent * event ){
       if (event->key()==Qt::Key_CapsLock) {
		//if (shortKeyToolButton::displayShortkey==false)
		{ 
			shortKeyToolButton::displayShortkey=!shortKeyToolButton::displayShortkey;
			update();	
		}
	}
QMainWindow::keyPressEvent( event);
}
void layout::keyReleaseEvent ( QKeyEvent * event ){
   /*    if (event->key()==Qt::Key_CapsLock) {
		if (shortKeyToolButton::displayShortkey==true){ 
			shortKeyToolButton::displayShortkey=false;
			update();	
		}
	}*/
QMainWindow::keyReleaseEvent( event);
}


void layout::hideUnusedLayers(){
}

void layout::hideCurrentUnusedLayers(){
}

void layout::disableUnusedLayers(){
}

void layout::enableAllLayer(){
  layers::enableAllLayer();
  drawing->macroAdd("layers::enableAllLayer();");
  emit updateSetupLayerbutton();
  drawing->paint();
}

void layout::booleanOnLayer(){
setup::ngpl();
}

void layout::trigger3dRenderAll(){
#ifdef USE_3d
if (view3dTool!=NULL) view3dTool->trigger3dRenderAll();
#endif
}

void layout::trigger3dRenderSelect(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->trigger3dRenderSelect();
#endif
}

void layout::trigger3dRenderAuto(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->trigger3dRenderAuto();
#endif
}

void layout::renderAll(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->renderAll();
#endif
}
void layout::renderSelect(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->renderSelect();
#endif
}
void layout::renderAuto(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->renderAuto();
#endif
}
void layout::renderOff(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->renderOff();
#endif
}
void layout::screenshot3dGui(){
setup::ngpl();
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->screenshot3dGui();
#endif
}
void layout::setup3d(){
#ifdef USE_3d
if (view3dTool!=NULL)view3dTool->setup3d();
#endif
}

void layout::screenshot3d(){
#ifdef USE_3d
if (view3dTool==NULL) return;
if (isGuiThread()){
QStringList filter;
QStringList png;
filter<<"dxf (*.dxf *.DXF)";
for (int i=0;i<QImageWriter::supportedImageFormats ().count();i++){
   QString f=QImageWriter::supportedImageFormats ().at(i);
   if (f!="png") {
	png <<f + " (*." + f.toLower() + " *." + f.toUpper() + ")";}
   else {
   	filter <<  f + " (*." + f.toLower() + " *." + f.toUpper() + ")";
	}
   }
    //printf("%s\n",QString(QImageIO::outputFormats().at(i)).latin1());}
 filter+=png;
 QFileDialog file;
 file.setAcceptMode ( QFileDialog::AcceptSave);
 if (filedialog::getLastPath()!="") file.setDirectory(filedialog::getLastPath());
 file.setWindowTitle(tr("3D data/screenshot save dialog"));
 file.setFilters(filter);
 file.setViewMode(QFileDialog::List);
 file.show();
 int k=file.exec();
 if (k==QDialog::Accepted) {
        QStringList files = file.selectedFiles();
        QString fn;
        if (!files.isEmpty()) fn = files[0];
	else return;
 	//QString fn=file.selectedFile();
	QString ext=file.selectedFilter();
	ext=ext.left(ext.indexOf (" ",0));
	if (fn.toUpper().indexOf("."+ext.toUpper(),0)==-1) {fn+="."+ext.toLower();}
	widget3d *wid3d=view3dTool->dockwindow3d->widget;
	if (wid3d==NULL) return;
	if (ext=="dxf") {
		workThread->startOperation("view3dExortDxf",fn);
		/*if (drawing->mutexReadGuiTryLock()) {
			
			view3dTool->exportDXF(fn);
			drawing->mutexReadUnlock();
			}*/
		}
	else {
		//QPixmap p= wid3d->renderPixmap(); 
		QImage p=wid3d->grabBuffer (  );
  		p.save(fn,ext.toLatin1(),-1);
	}
 	}
 else statusBar()->showMessage( tr("Saving aborted."), 2000 );
}
else {
   /*workThread->dataMutex.lock();
   emit workThread->askScreenshot();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
   if (fn!="") {
	widget3d *wid3d=view3dTool->dockwindow3d->widget;
	if (wid3d==NULL) return;
	QImage p=wid3d->grabBuffer (  );
  	p.save(fn,"png",-1);
		}*/
}
#endif
}

void layout::openSchematic(){
setup::ngpl();
#ifdef SCHEMATIC
schematic *s=project::getSchematic(this);
netlistTool->hideNetlistBox();
  if (drawing->mutexReadTryLock()) {
	QString cn=drawing->currentCell->cellName;
	drawing->mutexReadUnlock();
  	s->drawing->forceSheetGui(cn);
	s->drawing->updateNetlist();
  	}
s->show();
if (s->windowState()==Qt::WindowMinimized) s->showNormal();
s->setFocus();
s->raise();
#endif
}

#ifdef SCHEMATIC
schematic * layout::createSchematic(){
  if (isGuiThread()){
     return new schematic();
  }
  else {
		workThread->dataMutex.lock();
   		emit workThread->askSchematic();
   		workThread->waitOnGui.wait(&workThread->dataMutex);
		schematic *s=workThread->schematicWindow;
  		workThread->dataMutex.unlock();
		return s;
  }
}
#endif

QString layout::getText(QString caption,QString lable,QString value){
if (isGuiThread()){
   		return QInputDialog::getText(this,caption,lable,QLineEdit::Normal,value);
		}
	else {

		workThread->dataMutex.lock();
   		emit workThread->askText(caption,lable,value);
   		workThread->waitOnGui.wait(&workThread->dataMutex);
   		QString s=workThread->text;
  		workThread->dataMutex.unlock();
		return s;
		}

}
   
int layout::getInteger(QString caption,QString lable,int value){
  	if (isGuiThread()){
   		return QInputDialog::getInteger(this,caption,lable,value);
		}
	else {
		workThread->dataMutex.lock();
   		emit workThread->askInteger(caption,lable,value);
   		workThread->waitOnGui.wait(&workThread->dataMutex);
   		int i=(workThread->integer);
  		workThread->dataMutex.unlock();
		return i;
		}

}

double layout::getDouble(QString caption,QString lable,double value, int digits){
if (isGuiThread()){
   		return QInputDialog::getDouble(this,caption,lable,value, -1E99, 1E99 ,digits);
		}
	else {
		workThread->dataMutex.lock();
   		emit workThread->askDouble(caption,lable,value,digits);
   		workThread->waitOnGui.wait(&workThread->dataMutex);
   		double d=(workThread->d);
  		workThread->dataMutex.unlock();
		return d;
	}

}

int layout::getBool(QString caption,QString lable){
  	if (isGuiThread()){
	        return QMessageBox::information( this, caption,
				      lable,
				      tr("Yes"), tr("No"), QString::null,
				      0, 1 );
		}
	else {
		workThread->dataMutex.lock();
   		emit workThread->askBool(caption,lable);
   		workThread->waitOnGui.wait(&workThread->dataMutex);
   		int i=(workThread->integer);
  		workThread->dataMutex.unlock();
		return i;
		}

}

QString layout::getOpenFilename(){
if (isGuiThread()){
    return filedialog::getOpenFileName();
	}
else {
   workThread->dataMutex.lock();
   emit workThread->askOpenFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
   return fn;
   }
}

QString layout::getSaveFilename(){
if (isGuiThread()){
    return filedialog::getSaveFileName();
	}
else {
   workThread->dataMutex.lock();
   emit workThread->askSaveFilename();
   workThread->waitOnGui.wait(&workThread->dataMutex);
   QString fn=workThread->filename;
   workThread->dataMutex.unlock();
   return fn;
   }
}

void layout::showStatus(QString lable){
if (isGuiThread()){
	statusBar()->showMessage( lable, 2000 );}
else {
	emit workThread->showMessage(lable);
  }
}

void layout::showMessage(QString caption,QString text){
if (isGuiThread()){
   		QMessageBox::information(this,caption,text);
		}
else {
		workThread->dataMutex.lock();
   		emit workThread->askShowMessage(caption,text);
   		workThread->waitOnGui.wait(&workThread->dataMutex);
  		workThread->dataMutex.unlock();
	}
}

#ifdef TEXTEDIT
textEdit* layout::showTextEditor(bool exec){
 if (isGuiThread()){
  	textEdit *te=new textEdit();
	te->setWindowTitle( "TextEditor" );
	#ifdef PYTHON
	te->setDefaultGui();
	#endif
	if (exec){
	  te->toolBarAdd(tr("Exec"),"6000");
	  connect(te,SIGNAL(execute(QString)),this,SLOT(execute2Macro(QString)));
	}
	te->show();
	return te;
		}
else {
		workThread->dataMutex.lock();
		workThread->parameterBool=exec;
   		emit workThread->askTextEditor();
   		workThread->waitOnGui.wait(&workThread->dataMutex);
		textEdit *te=workThread->textEditor;
  		workThread->dataMutex.unlock();
		return te;
	} 
}
#endif

void layout::toggleSnapToGrid(){if (snapToGridButton!=0) singleButton[snapToGridButton]->processClick();};
void layout::toggleSnapToPoint(){setup::ngpl();if (snapToPointButton!=0) singleButton[snapToPointButton]->processClick();};
void layout::toggleSnapToMiddle(){setup::ngpl();if (snapToMiddleButton!=0) singleButton[snapToMiddleButton]->processClick();};
void layout::toggleSnapToLine(){setup::ngpl();if (snapToLineButton!=0) singleButton[snapToGridButton]->processClick();};
void layout::toggleSnapToCenter(){setup::ngpl();if (snapToCenterButton!=0) singleButton[snapToCenterButton]->processClick();};
void layout::toggleSnapToIntersection(){setup::ngpl();if (snapToIntersection!=0) singleButton[snapToIntersection]->processClick();};

void layout::openLayerManager(){
  if (setup==NULL) return;

 if (setupWindow::layerManagerWindow==NULL) setupWindow::layerManagerWindow=new layerManager();
 setupWindow::layerManagerWindow->open(drawing->userunits);
 if (setupWindow::layerManagerWindow->exec()==QDialog::Accepted) updateSetupLayerbutton();
}
void layout::showLastReport(){errorreport::showLastReport();}
void layout::showReport(QString s,int rang){  if (rang<=setup::showReport) {
 		 			reportview r(s);
 		 			r.exec();
		 			}}
void layout::macroAdd(QString s){drawing->macroAdd(s);}
void layout::paint(){drawing->paint();}
//obsoletes
void layout::newCell(){drawing->newCell();}; 
void layout::saveScreenshot(QString filename){drawing->saveScreenshot(filename);}


