/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LAYOUT_H
#define LAYOUT_H
/**
@author Juergen Thies
*/
#ifdef WINDOWS
#ifdef OPENACCESS
#include <winsock2.h>
// #define _WINSOCKAPI_
#endif
#endif
#include <QMainWindow>
#include <QResizeEvent>
#include <QCloseEvent>
#include <QMap>
#include <QComboBox>
#include <QPrinter>
#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include "widgets/mainwindow.h"


class lineEdit;
class newComboBox;
class cellCombo;
class layerTool;
class timewidget;
class poswidget;
class selectwidget;
class drawingField;
#ifdef barcodeutility
class barcodeModule;
#endif
#ifdef USE_3d
 class view3dModule;
#endif
#ifdef TEXTEDIT
 class textEdit;
#endif
#ifdef SCHEMATIC
class schematic;
#endif
#ifdef OPENACCESS
 class oaModule2;
#endif
#ifdef backgroundutility
class backgroundModule;
#endif
#ifdef extractionutility
class extractionModule;
#endif
enum viewModeType {	viewermode, basicmode , intermediatemode, fullmode, defaultmode,custommode, genisysmode,genisysmodenoopen,puremode};

class guiWorkThread;
class mouseHelp;
class booleanHandler;
class helpWindow;
class setupWindow;
class drc;
class gridwidget;

//! main widget class
/*!
  This class is the main widget of the windows from which the macro was executed. It is directly accessible via the classname "layout".
  @code
  layout->filename="/var/layouts/samples1.gds";<br>
  layout->newCell();
  @endcode 
  Most methods of this call require a user dialog. A direct access of the drawing is possible via the member drawing. 
  @link "Class drawingField;drawingField"
*/
class layout: public mainWindow
{
    Q_OBJECT
    
//#################################################################
// public modules

public:
//! head class of the drawing
/*!
This class is the main class of the drawing. It holds all relevant information. 
@link "Class drawingField;drawingField"
*/
    drawingField *drawing;  
    
//! boolean tool
/*!
The boolean utilities are accessible via this class.
@link "Class booleanHandler;booleanHandler"
*/
    booleanHandler *booleanTool;
    
//! design rule checker tool
/*!
The design rule checker is accessible via this class.
@link "Class drc;drc"
*/
    drc *drcTool;

//!filename
/*!
This string hold the current filename.
*/ 
     QString filename;
//! layout
/*!
Creates a new layout window
@nomacro
*/ 
//-    layout();

public slots:
//! open file
/*!
A file with the name fileName is opened.If the prevous design was change it is asked to save it.
@nomacro
*/
    void open(QString fileName);
//! close design
/*!
The current design will be removed and an empty design is shown like after the program start.
*/
    void closeDesign();
//! trigger 3d render all
/*!
renderAll will be called after the macro terminates.
OBSOLETE: Please use view3dTool->trigger3dRenderAll() instead.
*/
    void trigger3dRenderAll();
//! trigger 3d render select
/*!
renderSeclect will be called after the macro terminates.
OBSOLETE: Please use view3dTool->trigger3dRenderSelect() instead.
*/
    void trigger3dRenderSelect();
//! trigger 3d render auto
/*!
renderAuto will be called after the macro terminates.
OBSOLETE: Please use view3dTool->trigger3dRenderAuto() instead.
*/
    void trigger3dRenderAuto();


public:
//! set cell
/*!
You will be prompted to select a cell. The cell will be displayed.
*/ 
    void setCell();
//! set cellname
/*!
You will be prompted to enter a name for the current displayed cell.
*/ 
    void setCellname();  
  
//! execute macro
/*!
Another macro is executed. The execution of this macro stopped until the termination of the new started macro.
@param filename	filename of the macro.
*/ 
    int executeMacro(QString filename, QString parameter="");
//! file open
/*!
It opened a file dialog. The selected file will be loaded.
*/ 
    void choose();
//! file import
/*!
It opened a file dialog. The selected file will be imported.(= add to the existing file)
*/ 
    void chooseImport();
//! file save
/*!
The actual file will be saved. If filename is empty, you will be prompted to enter a filename.
*/ 
    void save();
//! file save as
/*!
You will be prompted to enter a filename. The actuell file will be saved.
*/ 
    void saveAs();
//! screenshot
/*!
The screen will be saved. You will be prompted to enter a filename.
*/ 
    void screenshot();
//! print
/*!
A printer dialog will be opened.
*/ 
    void print();


//##########################################################################################
//obsolete features

//! screenshot
/*!
The screen will be saved in the file with the name filename. The type is selected by the extension.
OBSOLETE: Please use drawing->saveScreenshot(QString filename) instead.
*/ 
    void saveScreenshot(QString filename);
//! group selected elements
/*!
All selected elements are moved to a new cell. A correlating cellref will be added.
OBSOLETE: Please use drawing->group() instead.
*/ 
    void group();
//! delete 
/*!
After a confirmation the current display cell will be deleted. If there are no more cell in the drawing, a new empty cell will be created.
OBSOLETE: Please use drawing->deleteCurrentCell() instead.
*/ 
    void deleteActuellCell();
//! new cell
/*!
A new empty cell will be added, named with an unused cell name and it is set as current cell.
OBSOLETE: Please use drawing->newCell() instead.
*/ 
    void newCell(); 
//##########################################################################################
//dialogs
public slots:  
  void execute2Macro(QString filename){ executeMacro(filename);}
//! get text
/*!
The user will be prompted to enter a text.
@param caption	the title of the window.
@param lable 	this string will be displayed inside the window.
@param value	default value
@return returns the text set by the user.*/
   QString getText(QString caption,QString lable,QString value="");
//! get integer
/*!
The user will be prompted to enter a integer.
@param caption 	the title of the window.
@param lable 	this string will be displayed inside the window.
@param value	default value
@return returns the integer set by the user.
*/
   int getInteger(QString caption,QString lable, int value=0);
//! get double
/*!
The user will be prompted to enter a double.
@param caption 	the title of the window.
@param lable 	this string will be displayed inside the window.
@param value	default value
@param digis	maximal number of digits 
@return returns the double set by the user.
*/    
   double getDouble(QString caption,QString lable,double value=0, int digits=1);
//! get bool
/*!
The user will be prompted to enter a bool.
@param caption 	the title of the window.
@param lable 	this string will be displayed inside the window.
@return returns 0 if yes, otherwise 1
*/    
   int getBool(QString caption,QString lable);
//! get open filename
/*!
A file open dialog is shown.
@return returns a string with the filename or a empty string if canceled
*/
   QString getOpenFilename();
//! get save filename
/*!
A file save dialog is shown.
@return returns a string with the filename or a empty string if canceled
*/
   QString getSaveFilename();
//! show message in statusbar
/*!
A message will be displayed in the statusbar for 2 seconds.
@param lable 	this string will be displayed in the statusbar.
*/
   void showStatus(QString lable);
//! show message
/*!
A message will be displayed.
@param caption	the title of the window.
@param label	this string will be displayed inside the window.
*/
   void showMessage(QString caption,QString label);
#ifdef TEXTEDIT
//! show text editor
/*!
Will create a new text Editor window in a thread save way.
*/
   textEdit* showTextEditor(bool exec=false);
#endif
//##########################################################################################
//Gui setup
  public:
//! set shortcut
/*!
Use this function to modify any existing shortcut. It returns true, if the modification was successful.
@code
		layout->setShortcut("&Sector",""); // remove old 'F' shortkey <br>
		layout->setShortcut("&Zoom Fit All","F"); // set 'F' to zoom fit<br>
		layout->setShortcut("&Zoom Fit Selection","Shift+F"); // set 'Shift F' to zoom fit selection<br>
@endcode

*/    
//-   bool setShortcut(QString function,QString key); 
//! add command line dock
/*!
Add a c/cpp commandline macro dock and make it invisible.
@nomacro
*/ 
   void addCommandLineDock();
//! add mouse help dock
/*!
Add a mouse help dock to the window and adds it to the left dock.
@nomacro
*/ 
   void addMouseHelp();
// ! add layer dock
/* !
Add a layer dock to the window and adds it to the left dock.
Add a layer menu to the main menu.
@nomacro
*/ 
   void addLayerDock(); 
    
//! add 3d view dock
/*!
Add a c/cpp companndline macro dock and make it invisible.
@nomacro
*/ 
   void add3dDock();
//! hide tool bar
/*!
Hides the named toolbar. 
*/ 
   void hideToolBar(QString name);
//! show tool bar
/*!
Shows the named toolbar. 
*/ 
   void showToolBar(QString name);
//! add tool bar
/*!
Add a new tool bar, separate multipli buttons with a ';'.
@code 
	layout->toolBarAdd("my toolbar","New Layout;Zoom Mouse;Code 39;Quit");
@endcode
*/ 
   void toolBarAdd(QString name,QString buttons );
//! last toolbar
/*!
@return a pointer to the last created toolBar
@nomacro
*/ 
   QToolBar * toolBarLast(){return toolBar[toolBarNext];}
//! add menu
/*!
Add a new entry to the main menu. The first parameter is the name of the menu. The second parameter contains last entries of the new menu seperated with a semicolon.
@nomacro
*/ 
   void menuAdd(QString name,QString entries );
//! get menu
/*!
Returns a point to the menu with the name. If the menu does not exist it will be created. To get submenus use 'mainentry/submenu' as name.
@nomacro
*/ 
//-QMenu *getMenu(QString name);
//! add macros
/*!
Macro in the macro folder will be added to the menu.
@nomacro
*/ 
//- void addMacros();
//! gui Update
/*!
The user interface is updated. It updates the setup of the layerbuttons, the list of existing cell ,.. Call this function after you have changed the design in a script. The c/c++ macro interface call the function automatic after the execution of a macro. 
@nomacro
*/ 
void guiUpdate();
//!debug mode
/*!
True if the debug mode is on.
*/ 
   static bool debug;
   static bool basicMode;
// optional modules
   
#ifdef barcodeutility
//! barcode tool
/*!
The barcode utilities are accessible via this class.
*/
    barcodeModule *barcodeTool;
#endif
#ifdef backgroundutility
//! background tool
/*!
The background utilities are accessible via this class.
*/
    backgroundModule *backgroundTool;
#endif
#ifdef extractionutility
    extractionModule *extractionTool;
#endif
#ifdef USE_3d
//! view 3d tool
/*!
The 3d view is accessable via this class
*/
    view3dModule *view3dTool;
#endif
#ifdef OPENACCESS
    oaModule2 *oaTool;
#endif

signals:
//! signal current cell changed
/*!
This signal is emitted when the current displayed cell has changed.
@nomacro
*/ 
    void newCurrentCell(const QString &s);
//! signal closed
/*!
This signal is emitted when the window is closed and destroyed
@nomacro
*/
    void closed();
//! signal cells change
/*!
This signal is emitted when cells has been added or deleted.
@nomacro
*/ 
  void cellsChanged(QStringList list,QString currentCell );

//#########################################################################################
// internal and private stuff, don't use anything blow

public:
    layout(viewModeType viewonly=fullmode);
    ~layout();
    QToolBar *commandLineTools;
    
    mouseHelp *mouseHelps;
    setupWindow *setup;
    void setCellCombo(QString);
    guiWorkThread *workThread;
    int executeMacroForce(QString filename, QString parameter="");
public slots:
    void commandlineActivate();
    void closeDesignGui();
    void setStatusBarSize(int width);
    void toggleMenu();
    void newDoc();
    void openSchematic();
    void chooseUpdate();
    void showGridToggle();
    void setTitle(QString s);
    void zeigeString(QString s);
    void zeigeMousePos(QPoint pos);
    void zeigeDifPos(QPoint pos,QPoint dif);
    QString getUserunits();
    void setUserunits(QString s);
    void aktiveLayerChange(int nr);
    void paint();
    void cellsUpdate();
    void currentCellUpdate();
    void addCellref();
    void addCellrefArray();
    void selectCellref();
    //menubar
    void showMenuBar();
    void hideMenuBar();
    bool isMenuBarVisible();
    //macro
    void macroStart(QString,QString);
    void macroAdd(QString s);
    void startMacroRecording();
    void stopMacroRecording();
    void generateTechnologyMacro();
    void generate3dSetupMacro();
    void generateViewMacro();
    void executeMacroGui();
    void editMacroGui();
    //grid
    void gridChange(const QString &s);
    void gridPlus();
    void gridMinus();
    void gridAuto();
    void gridAutoPlusMinus();
    void updateGrid();
    void setGrid();
    //layer
    void updateLayerbutton();
    void updateSetupLayerbutton();
    //debug
    void debugOnOff();
    void cleanElements();
    void compareCell();

    void hideUnusedLayers();
    void hideCurrentUnusedLayers();
    void disableUnusedLayers();
    void enableAllLayer();
    void screenshot3d();
    void renderAll();
    void renderSelect();
    void renderAuto();
    void renderOff();
    void screenshot3dGui();
    void setup3d();

public:
// lock GUI
    QMutex lockMutex;
    QWaitCondition lockWait;
    bool guiLocked;
public slots:
// lock GUI

    void lockGuiThread();
    void unlockGuiThread();
// guiThreadfunction for workthread dialogs
    void askSaveModifications();
    void askOpenFilename();
    void askSaveFilename();
    void askPrint();
    void askText(QString,QString,QString);
    void askDouble(QString,QString,double,int);
    void askInteger(QString,QString,int);
    void askBool(QString,QString);
    void askShowMessage(QString,QString);
    void askCell();
    void askScreenshot();
    void askCellName();
    void askTextEditor();
    void askSchematic();
    void showLastReport();
    void showReport(QString s,int rang);
    
//-------  


protected:
    void closeEvent( QCloseEvent* );
    void resizeEvent ( QResizeEvent * );
    void keyPressEvent ( QKeyEvent * event );
    void keyReleaseEvent ( QKeyEvent * event )  ;
    void windowActivationChange ( bool oldActive );

private slots:
// ---- slots for GUI
    void chooseUserunits();
    void toggleSnapToGrid();
    void toggleSnapToPoint();
    void toggleSnapToMiddle();
    void toggleSnapToLine();
    void toggleSnapToCenter();
    void toggleSnapToIntersection();
    void nextLayout();
    void invertSelect();
    void selectAll();
    void selectVisible();
    void deselectAll();
    void deSelectAll();
    void selectActiveLayer();
    void deselectActiveLayer();
    void pathSelect();
    void pathDeselect();
    void boxSelect(); 
    void boxDeselect();
    void polygonSelect(); 
    void polygonDeselect();
    void textSelect();
    void textDeselect();
    void mergeSelect();
    void deleteSelect();
    void cropWithSelection();
    void toBox();
    void toPolygon();
    void toCircle();
    void closedPathToPolygon();
    void copyCurrentCell();
    void undo();
    void redo();
    void clipboardCopy();
    void clipboardPaste();
    void screenshotGui();
    void chooseImportGui();
    void chooseUpdateGui();
    void chooseGui();
    void openImportGui();
    void openImportUpdateGui();
    void saveGui();
    void saveAsGui();
    void saveAsSaveGui();
    void printGui();
    void setCellnameGui();
    void newCellGui();
    void deleteActuellCellGui();
    void flat();
    void flatAll();
    void setCellGui();
    void emitNewCurrentCell(const QString &s);
    void groupGui();
    void groupSimpleGui();
    void groupStructureGui();
    void groupGlobalGui();
    void flatDialogGui();
    void groupDialogGui();
    void commandLineEnter();
    void areaSelect();
    void extractCell();
    void extractLayer();
    void showExtraction();
    void stripUnneeded();
    void stripEmptyCells();
    void removeScaledCellref();
    void removeCellArrays();
    void removeNotOrthogonalCellref();
    void copyLayer();
    void moveLayer();
    void moveBy();
    void copyBy();
    void gotoxy();
    void modifyCorners();
    void toMeshSelect();
    void sizeadjustSelect();
    void roundSelect();
    void snapShapesSelect();
    void edgeRemoveSelect();
    void cropSharpAnglesSelect();
    void stripIdenticalElements();
    void openLayerManager();
    void drcMinDistance();
    void drcInside();
    void drcGrid();
    void drcMinSize();
    void drcMinOverlap();
    void drcMinElementDistance();
    void drcMinDistanceOrOverlap();
    void drcLayerCombination();
    void drcEnclosure();
    void drcOverlapDistance();
    void drcDimension();
    void drcNoHoles();
    void drcAngles();
    void drcArea();
    void drcPerimeter();
    void drcNotches();
    void booleanOnLayer();
    void toggleRenderText();
    void toggleShowCellRefs();
//-----
    
    
signals:
    void lastFilesAdd(QString);
    void updateGui();
    
private: 
    bool commandlineTab;
    int snapToPointButton,snapToGridButton, snapToMiddleButton,snapToLineButton, snapToCenterButton, snapToIntersection;
    layerTool *layerTools;
    viewModeType viewMode;
    cellCombo *cellcombo;
    newComboBox *gridcombo;
    int macroMultiButton;
    void spezialToolbar(int num);
    virtual void getFunctionInfo(int function, QString *textLabel, QObject ** receiver, const char ** slot,helpText *helptext);
    selectwidget *selectStatus;
    gridwidget *gridStatus;
    timewidget *timeStatus;
    poswidget *posStatus;
    bool userGridChange;
    lineEdit *commandLine;
    void setFileName(QString oldName,QString newName);
#ifdef SCHEMATIC
    schematic * createSchematic();
#endif
    
   friend class setup;
   friend class project;
   friend class cellCombo;
   friend class selectwidget;
   void noSaveMessage();
};


#endif
