/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "elements/elementlist.h"



void macro::elementListHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="elementList";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::elementListHandler_typeHandler;
}
void macro::elementListHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrElementList,varElementList,single);
}

returnValue macro::elementListHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
if (r->type==ptrElementList){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varElementList){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 elementList *l=r->getElementList();
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="thisElement")){
 		returnValue r2;
		r2.setType(ptrElement);
		r2.deleteAfter=false;
		r2.Element=(l->thisElement);
		r2=elementHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
 else if ((p.type==keyword)&&(p.value=="nextElement")){
 		returnValue r2;
		r2.setType(ptrElementList);
		r2.deleteAfter=false;
		r2.ElementList=(l->nextElement);
		r2=elementListHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
 else {
  	error->addItem(tr("Class elementList has no member")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}


