/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "net/netlistdevice.h"




void macro::netListDeviceHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="netListDevice";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::netListDeviceHandler_typeHandler;
}

void macro::netListDeviceHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrNetListDevice,varNetListDevice,single);
}

returnValue macro::netListDeviceHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrNetListDevice){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 netListDevice *d= r->getNetListDevice();
 p=next(counter);
 if ((p.type==keyword)&&(p.value=="cellname")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->cellname);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 else if ((p.type==keyword)&&(p.value=="devicename")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->devicename);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 // methods
 else if (((p.type==keyword)&&(p.value=="getConnectionNames"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setStringList(d->getConnectionNames());
	ret=stringListHandler_classHandler(counter,keyword_,&ret,false);
	}
 else if (((p.type==keyword)&&(p.value=="connectionsCount"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setInt(d->connectionsCount());
	}
 else if (((p.type==keyword)&&(p.value=="getNode"))) { testParenOpen(counter); 
	returnValue pos1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(d->getNode(pos1.getString()));
	}

 else {
  	error->addItem(tr("Class netlistdevice has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}


