/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"



void macro::pointArrayHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="pointArray";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::pointArrayHandler_typeHandler;
}
void macro::pointArrayHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrPointArray,varPointArray,single);
}

returnValue macro::pointArrayHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
if (r->type==ptrPointArray){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varPointArray){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 pointArray *c= r->getPointArray();
 p=next(counter);

 // methods
 if (((p.type==keyword)&&(p.value=="point"))) {
 	testParenOpen(counter);
	returnValue i=calculate(counter,keyword_);
	testParenClose(counter);
	ret.setPoint(c->point(i.getInt()));
	ret=pointHandler_classHandler(counter,keyword_,&ret,left);
  	}
 else {
  	error->addItem(tr("Class pointArray has no member")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

