/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cellcombo.h"

#include <qimage.h>
#include <qstatusbar.h>
#include <qpainter.h>
//#include <q3paintdevicemetrics.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
//#include <q3whatsthis.h>
#include "icons/gridautoicon.xpm"
#include "icons/selectgridicon.xpm"
#include "dialog/helpwindow.h"
#include <QMenu>
#include "layout.h"

cellCombo::cellCombo(QWidget *parent, class layout *la)
 : newComboBox(parent)
{
  l=la;

}
    
cellCombo::~cellCombo()
{

}


void cellCombo::contextMenuEvent ( QContextMenuEvent * event) {
  if (QApplication::keyboardModifiers ()!=Qt::NoModifier) {event->ignore();return;}
if (l->viewMode==viewermode) return;
QMenu menu;
menu.addAction(helpWindow::getIcon(setCellnameHelp),helpWindow::getMenuname(setCellnameHelp),l,SLOT(setCellnameGui()));
menu.addAction(helpWindow::getIcon(deleteCellHelp),helpWindow::getMenuname(deleteCellHelp),l,SLOT(deleteActuellCellGui()));
menu.addAction(helpWindow::getIcon(newCellHelp),helpWindow::getMenuname(newCellHelp),l,SLOT(newCellGui()));
#ifdef FULL_VERSION
//menu.addAction(helpWindow::getIcon(autoGridHelp),helpWindow::getMenuname(autoGridHelp),l,SLOT(gridAuto()));
//menu.addAction(helpWindow::getIcon(showGridHelp),helpWindow::getMenuname(showGridHelp),l,SLOT(showGridToggle()));
//menu.addSeparator();
// menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// reset layer
// restore layer
// store layer as
// menu.addSeparator();
//menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// layer setup ???
#endif
menu.exec(QCursor::pos());

}
