/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "lineedit.h"
#include <QKeyEvent>
#include "layout.h"
#include <QWhatsThis>
#include <QEvent>
lineEdit::lineEdit()
 : QLineEdit()
{
    commandList.clear();
    pos=-1;
    
   help=setSubfunctionHelp;
   setWhatsThis("No Documentation!");

}


lineEdit::lineEdit( QWidget * parent ){
      commandList.clear();
    pos=-1;
    
   help=setSubfunctionHelp;
   setWhatsThis("No Documentation!");
}

lineEdit::~lineEdit()
{
}
void lineEdit::enterEvent ( QEvent * e ){
  mouseWidget::set(help);
  QLineEdit::enterEvent(e);
}



bool lineEdit::event( QEvent *e){
   if (e->type() == QEvent::ShortcutOverride ) {
        QKeyEvent* ke = (QKeyEvent*) e;
        if (ke->modifiers() == Qt::NoModifier || ke->modifiers() == Qt::ShiftModifier
            || ke->modifiers() == Qt::KeypadModifier) {
            if (ke->key() < Qt::Key_Escape) {
                ke->accept();
            } else {
                switch (ke->key()) {
                case Qt::Key_Delete:
                case Qt::Key_Home:
                case Qt::Key_End:
                case Qt::Key_Backspace:
                case Qt::Key_Left:
		case Qt::Key_Up:
		case Qt::Key_Down:
                case Qt::Key_Right:
                    ke->accept();
                default:
                    break;
                }
            }
		//printf("key:%d type: %d\n",ke->key(),e->type());

    }}
    if (e->type() == 
            (QEvent::WhatsThis)) {
	//QWhatsThis::hideText ();
	  layout::helpwindow->showHelp(help);
	  QWhatsThis::leaveWhatsThisMode ();
	  return true;
	}
return QLineEdit::event(e);
}

void lineEdit::keyReleaseEvent ( QKeyEvent * event ){
QLineEdit::keyReleaseEvent ( event );
}

void lineEdit::keyPressEvent ( QKeyEvent * event ){
//printf("pressed:%d\n",event->key());
      if (event->key()==Qt::Key_Escape) {
			//printf("esc\n");
			clear();
			pos=-2;
			event->accept();
		}
      else if ((event->key()==Qt::Key_Enter)||(event->key()==Qt::Key_Return)){
		//printf("enter \n");
		if (text()!="") commandList<<text();
		if (commandList.size()>100) commandList.erase(commandList.begin(),commandList.begin()++);
		pos=-2;
		QLineEdit::keyPressEvent ( event );
	}
      else if (event->key()==Qt::Key_Up){
		//printf("up\n");
		if (pos==-2) pos=commandList.size()-1;
		else  pos--;
		if (pos<-1) pos=-1;
		else if ((pos>=0)&&(pos<commandList.size())) setText(commandList.at(pos));
		else clear();
		//printf("pos: %d size %d\n",pos,commandList.size());
		event->accept();
	}
      else if (event->key()==Qt::Key_Down){
		//printf("donw\n");
		pos++;
		if ((pos<commandList.size())&&(pos>=0)) setText(commandList.at(pos));
		else {clear();
			pos=-2;}
		//printf("pos: %d size %d\n",pos,commandList.size());
		event->accept();
	}
	else QLineEdit::keyPressEvent ( event );
}
