/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MULTITOOLBUTTON_H
#define MULTITOOLBUTTON_H

#include <qtoolbutton.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <QMenu>
//Added by qt3to4:
#include <QMouseEvent>
#include <QEvent>
#include "subtoolbutton.h"
#include <QToolBar>
#include "widgets/shortkeytoolbutton.h"
/**
@author Juergen Thies
*/

#define max_subButton 30


class multiToolButton : public shortKeyToolButton
{
Q_OBJECT
public:
 
  QPixmap icon;
  
 
private:
  int mode;
public:
  multiToolButton(QToolBar *parent,const QIcon & iconSet);
  
  ~multiToolButton();
  int fuctionNum;
  subToolButton button[max_subButton];
  QWidget *subWidget;
protected:
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void mouseReleaseEvent(QMouseEvent *e);
  void enterEvent ( QEvent * e );
  bool event(QEvent * e);
public:
  void addToolButton(int index, const QIcon & iconSet,const QString & textLabel, const QString & grouptext, QObject * receiver, const char * slot, const char * name = 0,QString whatthis=QString::null,helpText help=clear);
  void addToolButton(int index, const QString & textLabel, QObject * receiver, const char * slot, helpText help=clear,int mode=-1);
 
  void makeWidget();
public slots:
  void activated(int num);
  void set(int num);
  void modeChanged(int oldMode,int newMode);
signals:
  //void clicked();
};

#endif
