/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "shortkeybutton.h"
#include "general/layers.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include <qbitmap.h>


shortKeyButton::shortKeyButton( QWidget *parrent)
 : QPushButton(parrent), shortKey()
{
 sk="";
 input=false;
 connect(this,SIGNAL(clicked()),this,SLOT(activate()));
 installEventFilter(this);
}


shortKeyButton::~shortKeyButton()
{
}
void shortKeyButton::setShortKey(QString sk_){
sk=sk_;
if (sk=="") setText(tr("none"));
else setText(sk);
}

QString shortKeyButton::getShortKey(){
return sk;
}
void shortKeyButton::activate(){
	input=true;
	setFocus();
}

void shortKeyButton::focusOutEvent ( QFocusEvent *  ){
	if (input){
		input=false;
		setShortKey(sk);
	}
}

bool shortKeyButton::eventFilter(QObject *obj, QEvent *e){
     if (e->type() == QEvent::ShortcutOverride) {
			if (input) {
				e->accept();
				return false;
			} }
     if ((e->type() == QEvent::KeyPress)&&(input)) {
                QKeyEvent *keyEvent = static_cast<QKeyEvent *>(e);
            if ((keyEvent->key()!=Qt::Key_Shift)&&(keyEvent->key()!=Qt::Key_Control)&&
				(keyEvent->key()!=Qt::Key_Meta)&&(keyEvent->key()!=Qt::Key_Alt)){
				QString mod=getModifiers(keyEvent->modifiers ());
				QString key=getKey(keyEvent->key());
				if (key!="none") {
					setShortKey(mod+key);
					input=false;
				}
				else
				{ 
					setShortKey("");
					input=false;
				}
				return true;}
	 }
return QPushButton::eventFilter(obj, e);
}
