/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "singletoolbutton.h"
#include "layout.h"
#include <QWhatsThis>
#include <QAction>
#include "dialog/helpwindow.h"

singleToolButton::singleToolButton (QWidget *parent ):shortKeyToolButton(parent) {
helpMouse  =clear;
setWhatsThis("No help available.");
}

singleToolButton::singleToolButton(const QIcon & iconSet, const QString & textLabel, QObject * receiver, const char * slot, QToolBar * parent,QString WhatThis,helpText helptext )
 : shortKeyToolButton(parent) 
{
  setIcon(iconSet);
  setToolTip(textLabel);
  setWhatsThis(WhatThis);
  setAutoRaise (false );
  connect(this,SIGNAL(clicked()),receiver,slot);
  parent->addWidget(this);
helpMouse  = helptext;
  mode=-1;
}

singleToolButton::singleToolButton ( const QIcon & iconSet, const QString & textLabel, bool * b, QToolBar * parent,QString WhatThis,helpText helptext  ) : shortKeyToolButton(parent )  {
  setIcon(iconSet);
  setToolTip(textLabel);
  setWhatsThis(WhatThis);
  setAutoRaise (true );
  setCheckable ( true);
  connect(this,SIGNAL(clicked()),this,SLOT(processClick()));
  parent->addWidget(this);
 helpMouse  = helptext;
 boolValue=b;
 setChecked (*b);
  mode=-1;
}

singleToolButton::singleToolButton( const QString & textLabel, QObject * receiver, const char * slot, QToolBar * parent,helpText helptext )
 : shortKeyToolButton(parent) 
{
  setIcon(layout::helpwindow->getIcon(helptext));
  setToolTip(textLabel);
  setWhatsThis("No help available.");
  setAutoRaise (true );
  connect(this,SIGNAL(clicked()),receiver,slot);
  parent->addWidget(this);     
helpMouse  = helptext;
  mode=-1;
}

singleToolButton::singleToolButton ( const QString & textLabel, bool * b, QToolBar * parent, helpText helptext  ) : shortKeyToolButton(parent )  {
  setIcon(layout::helpwindow->getIcon(helptext));
  setToolTip(textLabel);
  setWhatsThis(" ");
  setAutoRaise (true );
  setCheckable ( true);
  connect(this,SIGNAL(clicked()),this,SLOT(processClick()));
  parent->addWidget(this);     
 helpMouse  = helptext;
 boolValue=b;
 setChecked (*b);
  mode=-1;
}


singleToolButton::~singleToolButton()
{
}

void singleToolButton::setIndicator( bool * b){
  setAutoRaise (true );
  setCheckable ( true);
 boolValue=b;
 setChecked (*b);
}

void singleToolButton::processClick(){
   *boolValue = !(*boolValue);
   setChecked (*boolValue);
}

void singleToolButton::setMode(int mode_){
 setAutoRaise (true );
 setCheckable ( true);
 setChecked (false);
 mode=mode_;
}


void singleToolButton::modeChanged(int oldMode,int newMode){
if (oldMode==mode) {setChecked (false);}
if (newMode==mode) {setChecked (true);}
else if (isChecked()){setChecked (false);}
}

bool singleToolButton::event(QEvent * event){
  if (event->type() == QEvent::WhatsThis) {
	//QWhatsThis::hideText ();
	layout::helpwindow->showHelp(helpMouse);
	QWhatsThis::leaveWhatsThisMode ();
	return true;
	}
  if (event->type() ==  QEvent::Enter) {
	update();
	//return false;
	}
  if (event->type() ==  QEvent::Leave) {
	update();
	//return false;
	}
  return QToolButton::event( event);
}
