/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tool3dbutton.h"
#include "layout.h"
#include <QWhatsThis>
#include <QAction>
#include "dialog/helpwindow.h"
#include "widgets/mousewidget.h"
#ifdef USE_3d
#include "3d/window3d.h"
#include "3d/widget3d.h"
#include "3d/view3dmodule.h"
#endif

tool3dButton::tool3dButton ( const QString & textLabel, QToolBar * parent,class layout *la,int i, helpText helptext  ) 
 : QToolButton(parent) 
{
  l=la;
  setIcon(layout::helpwindow->getIcon(helptext));
  setToolTip(textLabel);
  setWhatsThis("No help available.");
  setAutoRaise (true );
  parent->addWidget(this);     
  helpMouse  = helptext;
  axis=i;
}


tool3dButton::~tool3dButton()
{
}

void tool3dButton::mousePressEvent(QMouseEvent *e){
if (e->button()==Qt::LeftButton) {presspos=e->pos();}
}

void tool3dButton::enterEvent ( QEvent * e ){
mouseWidget::set(helpMouse);
QToolButton::enterEvent(e);
showAngles();
}

void tool3dButton::mouseMoveEvent(QMouseEvent *e){
double a,b,c;
#ifdef USE_3d
a=l->view3dTool->get3dAngleA();
b=l->view3dTool->get3dAngleB();
c=l->view3dTool->get3dAngleC();
QPoint p=presspos-e->pos();
double d=(double)(p.x())+((double)(p.y())/4.0);
switch (axis){
case 1: a+=d;
	break;
case 2: b+=d;
	break;
case 3: c+=d;
	break;

}
l->view3dTool->set3dPerspective(a,b,c);
showAngles();
presspos=e->pos();
QToolButton::mouseMoveEvent(e);
#endif
}

void tool3dButton::showAngles(){
#ifdef USE_3d
widget3d *wid3d=l->view3dTool->dockwindow3d->widget;
if (wid3d==NULL) return;
wid3d->showAngles();
#endif

}

bool tool3dButton::event(QEvent * event){
  if (event->type() == QEvent::WhatsThis) {
	//QWhatsThis::hideText ();
	layout::helpwindow->showHelp(helpMouse);
	QWhatsThis::leaveWhatsThisMode ();
	return true;
	}
  return QToolButton::event( event);
}
