/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.adapter;

import java.util.*;
import jp.gr.java_conf.jaba2.util.D2Array;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * TabAdapter
 *
 * @since   Nov. 14, 1998
 * @version Sep. 16, 2001
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class TabAdapter extends AbstractAdapter implements ITableAdapter {
    // AbstractAdapter
    protected Content[] _expand(
	String[] srcs,
	String param,
	Content content,
	Content[] contents,
	DocContext context
    ) {
	return (UDoc.table2Tr(getTable(srcs[0], param, context), content));
    }

    /**
     * @param query  adapter specific query
     */
    public SmartDocTableModel getTable(
	String src,
	String query,
	DocContext context
    ) {
	return (parseTable(USmartDoc.importText(src, context), query));
    }

    public SmartDocTableModel parseTable(String text, String query) {
	query = null;		// XXX
	D2Array data = new D2Array();
	String[] list = UString.makeStringListFromString(text);
	for (int y = 0;y < list.length;y++) {
	    StringTokenizer st = new StringTokenizer(list[y], "\t");
	    int size = st.countTokens();
	    for (int x = 0;x < size;x++) {
		data.put(x, y, st.nextToken());
	    }
	}
	return (new SimpleSmartDocTableModel(data));
    }
}
