package jp.gr.java_conf.jaba2.awt;

import java.awt.Frame;
import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

/**
 * ShowDialog
 *
 * @version Jul. 14, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ShowDialog extends ActionDialog {
    protected Component comp_;

    public ShowDialog(Frame frame, String title, Component comp) {
	super(frame, title, true); // Modal
	setContentPane(new ShowPanel(comp));
	comp_ = comp;
	pack();
    }

    public ShowDialog(Component parent, String title, Component comp) {
	super(JOptionPane.getFrameForComponent(parent), title, true); // Modal
	setContentPane(new ShowPanel(comp));
	comp_ = comp;
	pack();
    }

    public Component getComponent() {
	return (comp_);
    }

    class ShowPanel extends JComponent {
	public ShowPanel(Component comp) {
	    Action actions[] = new Action[1];
	    actions[0] = new AbstractAction() {
		public void actionPerformed(ActionEvent evt) {
		    setActionCommand("ok");
		    _fireActionPerformed();
		    ShowDialog.this.setVisible(false);
		    ShowDialog.this.dispose();
		}
	    };
	    actions[0].putValue(Action.NAME, "OK");
	    // _putValue(actions[0], Action.NAME, "OK");
	    OptionBar options = new OptionBar(actions);
	    setLayout(new BorderLayout());
	    add(comp, "Center");
	    add(options, "South");
	}
    }

    public static void main(String[] args) throws Exception {
	JDialogTestFrame frame = new JDialogTestFrame();
	ShowDialog dialog = new ShowDialog(frame, "Test", new javax.swing.JLabel("Label"));
	dialog.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		System.out.println("event = " + evt.getActionCommand());
	    }
	});
	frame.testDialog(dialog);
    }
}
