package jp.gr.java_conf.jaba2.awt;

/**
 * TableLayoutConstraints
 *
 * @since   Apr. 19, 1998
 * @version Jul. 15, 1998
 * @author ASAMI, Tomoharu (tasami@ibm.net)
 */
public class TableLayoutConstraints implements Cloneable {
    // POSITION
    public static final int POSITION_CURRENT = -1;
    public static final int POSITION_NEXT = -2;
    public static final int POSITION_PREVIOUS = -3;
    // ACTION
    public static final int ACTION_STAY = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FIRST = 3;

    public int x = POSITION_CURRENT;
    public int y = POSITION_CURRENT;
    public int xaction = ACTION_NEXT;
    public int yaction = ACTION_STAY;

    public TableLayoutConstraints() {
    }

    public TableLayoutConstraints(int x) {
	this.x = x;
    }

    public TableLayoutConstraints(int x, int y) {
	this.x = x;
	this.y = y;
    }

    public TableLayoutConstraints(int x, int y, int xaction, int yaction) {
	this.x = x;
	this.y = y;
	this.xaction = xaction;
	this.yaction = yaction;
    }

    public static TableLayoutConstraints makeNext() {
	return (new TableLayoutConstraints());
    }

    public static TableLayoutConstraints makeLast() {
	return (new TableLayoutConstraints(
	    POSITION_CURRENT,
	    POSITION_CURRENT,
	    ACTION_FIRST,
	    ACTION_NEXT
	));
    }	    

    public static TableLayoutConstraints makeFirst() {
	return (new TableLayoutConstraints(
	    0,
	    POSITION_NEXT,
	    ACTION_NEXT,
	    ACTION_STAY
	));
    }
}
